package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Единица времени сегмента разбиения
 */
public enum SplitUnit {
  
  MINUTE("minute"),
  
  HOUR("hour"),
  
  DAY("day"),
  
  WEEK("week"),
  
  MONTH("month"),
  
  YEAR("year");

  private String value;

  SplitUnit(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SplitUnit fromValue(String value) {
    for (SplitUnit b : SplitUnit.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

