package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.OffsetAmount;
import dev.vality.anapi.v2.model.SplitUnit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * SplitAmountResult
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class SplitAmountResult   {
  @JsonProperty("splitUnit")
  private SplitUnit splitUnit;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("offsetAmounts")
  @Valid
  private List<OffsetAmount> offsetAmounts = new ArrayList<>();

  public SplitAmountResult splitUnit(SplitUnit splitUnit) {
    this.splitUnit = splitUnit;
    return this;
  }

  /**
   * Get splitUnit
   * @return splitUnit
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public SplitUnit getSplitUnit() {
    return splitUnit;
  }

  public void setSplitUnit(SplitUnit splitUnit) {
    this.splitUnit = splitUnit;
  }

  public SplitAmountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public SplitAmountResult offsetAmounts(List<OffsetAmount> offsetAmounts) {
    this.offsetAmounts = offsetAmounts;
    return this;
  }

  public SplitAmountResult addOffsetAmountsItem(OffsetAmount offsetAmountsItem) {
    this.offsetAmounts.add(offsetAmountsItem);
    return this;
  }

  /**
   * Get offsetAmounts
   * @return offsetAmounts
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<OffsetAmount> getOffsetAmounts() {
    return offsetAmounts;
  }

  public void setOffsetAmounts(List<OffsetAmount> offsetAmounts) {
    this.offsetAmounts = offsetAmounts;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitAmountResult splitAmountResult = (SplitAmountResult) o;
    return Objects.equals(this.splitUnit, splitAmountResult.splitUnit) &&
        Objects.equals(this.currency, splitAmountResult.currency) &&
        Objects.equals(this.offsetAmounts, splitAmountResult.offsetAmounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(splitUnit, currency, offsetAmounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitAmountResult {\n");
    
    sb.append("    splitUnit: ").append(toIndentedString(splitUnit)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    offsetAmounts: ").append(toIndentedString(offsetAmounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

