package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.AmountResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Список балансов магазина 
 */
@ApiModel(description = "Список балансов магазина ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class ShopAmountResult   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("amountResults")
  @Valid
  private List<AmountResult> amountResults = null;

  public ShopAmountResult id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public ShopAmountResult amountResults(List<AmountResult> amountResults) {
    this.amountResults = amountResults;
    return this;
  }

  public ShopAmountResult addAmountResultsItem(AmountResult amountResultsItem) {
    if (this.amountResults == null) {
      this.amountResults = new ArrayList<>();
    }
    this.amountResults.add(amountResultsItem);
    return this;
  }

  /**
   * Get amountResults
   * @return amountResults
  */
  @ApiModelProperty(value = "")

  @Valid

  public List<AmountResult> getAmountResults() {
    return amountResults;
  }

  public void setAmountResults(List<AmountResult> amountResults) {
    this.amountResults = amountResults;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShopAmountResult shopAmountResult = (ShopAmountResult) o;
    return Objects.equals(this.id, shopAmountResult.id) &&
        Objects.equals(this.amountResults, shopAmountResult.amountResults);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, amountResults);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShopAmountResult {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    amountResults: ").append(toIndentedString(amountResults)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

