package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.FileMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Report
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class Report   {
  @JsonProperty("id")
  private Long id;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("fromTime")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime fromTime;

  @JsonProperty("toTime")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime toTime;

  /**
   * Статус формирования отчета
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    CREATED("created"),
    
    CANCELED("canceled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  /**
   * Тип отчета
   */
  public enum ReportTypeEnum {
    PROVISIONOFSERVICE("provisionOfService"),
    
    PAYMENTREGISTRY("paymentRegistry"),
    
    PAYMENTREGISTRYBYPAYOUT("paymentRegistryByPayout");

    private String value;

    ReportTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ReportTypeEnum fromValue(String value) {
      for (ReportTypeEnum b : ReportTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("reportType")
  private ReportTypeEnum reportType;

  @JsonProperty("partyID")
  private String partyID;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("files")
  @Valid
  private List<FileMeta> files = new ArrayList<>();

  public Report id(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор отчета
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор отчета")
  @NotNull


  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Report createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Report fromTime(OffsetDateTime fromTime) {
    this.fromTime = fromTime;
    return this;
  }

  /**
   * Дата и время начала периода
   * @return fromTime
  */
  @ApiModelProperty(required = true, value = "Дата и время начала периода")
  @NotNull

  @Valid

  public OffsetDateTime getFromTime() {
    return fromTime;
  }

  public void setFromTime(OffsetDateTime fromTime) {
    this.fromTime = fromTime;
  }

  public Report toTime(OffsetDateTime toTime) {
    this.toTime = toTime;
    return this;
  }

  /**
   * Дата и время конца периода
   * @return toTime
  */
  @ApiModelProperty(required = true, value = "Дата и время конца периода")
  @NotNull

  @Valid

  public OffsetDateTime getToTime() {
    return toTime;
  }

  public void setToTime(OffsetDateTime toTime) {
    this.toTime = toTime;
  }

  public Report status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус формирования отчета
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус формирования отчета")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Report reportType(ReportTypeEnum reportType) {
    this.reportType = reportType;
    return this;
  }

  /**
   * Тип отчета
   * @return reportType
  */
  @ApiModelProperty(required = true, value = "Тип отчета")
  @NotNull


  public ReportTypeEnum getReportType() {
    return reportType;
  }

  public void setReportType(ReportTypeEnum reportType) {
    this.reportType = reportType;
  }

  public Report partyID(String partyID) {
    this.partyID = partyID;
    return this;
  }

  /**
   * Идентификатор участника
   * @return partyID
  */
  @ApiModelProperty(required = true, value = "Идентификатор участника")
  @NotNull

@Size(min = 1, max = 40) 
  public String getPartyID() {
    return partyID;
  }

  public void setPartyID(String partyID) {
    this.partyID = partyID;
  }

  public Report shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(value = "Идентификатор магазина")

@Size(min = 1, max = 40) 
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Report files(List<FileMeta> files) {
    this.files = files;
    return this;
  }

  public Report addFilesItem(FileMeta filesItem) {
    this.files.add(filesItem);
    return this;
  }

  /**
   * Get files
   * @return files
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<FileMeta> getFiles() {
    return files;
  }

  public void setFiles(List<FileMeta> files) {
    this.files = files;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Report report = (Report) o;
    return Objects.equals(this.id, report.id) &&
        Objects.equals(this.createdAt, report.createdAt) &&
        Objects.equals(this.fromTime, report.fromTime) &&
        Objects.equals(this.toTime, report.toTime) &&
        Objects.equals(this.status, report.status) &&
        Objects.equals(this.reportType, report.reportType) &&
        Objects.equals(this.partyID, report.partyID) &&
        Objects.equals(this.shopID, report.shopID) &&
        Objects.equals(this.files, report.files);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, fromTime, toTime, status, reportType, partyID, shopID, files);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Report {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    fromTime: ").append(toIndentedString(fromTime)).append("\n");
    sb.append("    toTime: ").append(toIndentedString(toTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reportType: ").append(toIndentedString(reportType)).append("\n");
    sb.append("    partyID: ").append(toIndentedString(partyID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

