package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.BankCardDetails;
import dev.vality.anapi.v2.model.BankCardPaymentSystem;
import dev.vality.anapi.v2.model.BankCardTokenProvider;
import dev.vality.anapi.v2.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentToolDetailsBankCard
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class PaymentToolDetailsBankCard extends PaymentToolDetails  {
  @JsonProperty("cardNumberMask")
  private String cardNumberMask;

  @JsonProperty("bin")
  private String bin;

  @JsonProperty("lastDigits")
  private String lastDigits;

  @JsonProperty("paymentSystem")
  private BankCardPaymentSystem paymentSystem;

  @JsonProperty("tokenProvider")
  private BankCardTokenProvider tokenProvider;

  public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Маскированый номер карты
   * @return cardNumberMask
  */
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  @NotNull

@Pattern(regexp = "^\\d{6,8}\\*+\\d{2,4}$") 
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public PaymentToolDetailsBankCard bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * BIN банка-эмитента карты
   * @return bin
  */
  @ApiModelProperty(value = "BIN банка-эмитента карты")

@Pattern(regexp = "^(\\d{0}|\\d{6,8})$") 
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Последние цифры номера карты
   * @return lastDigits
  */
  @ApiModelProperty(value = "Последние цифры номера карты")

@Pattern(regexp = "^\\d{2,4}$") 
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public PaymentToolDetailsBankCard paymentSystem(BankCardPaymentSystem paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Get paymentSystem
   * @return paymentSystem
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public BankCardPaymentSystem getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(BankCardPaymentSystem paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public PaymentToolDetailsBankCard tokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Get tokenProvider
   * @return tokenProvider
  */
  @ApiModelProperty(value = "")

  @Valid

  public BankCardTokenProvider getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(BankCardTokenProvider tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard) o;
    return Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) &&
        Objects.equals(this.bin, paymentToolDetailsBankCard.bin) &&
        Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, paymentToolDetailsBankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsBankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

