package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.InternationalBankDetails;
import dev.vality.anapi.v2.model.InternationalCorrespondentBankAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные международного банковского счёта
 */
@ApiModel(description = "Данные международного банковского счёта")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class InternationalBankAccount   {
  @JsonProperty("number")
  private String number;

  @JsonProperty("iban")
  private String iban;

  @JsonProperty("bankDetails")
  private InternationalBankDetails bankDetails;

  @JsonProperty("correspondentBankAccount")
  private InternationalCorrespondentBankAccount correspondentBankAccount;

  public InternationalBankAccount number(String number) {
    this.number = number;
    return this;
  }

  /**
   * Номер счёта 
   * @return number
  */
  @ApiModelProperty(example = "123006951", value = "Номер счёта ")

@Pattern(regexp = "^[0-9A-Z]{8,40}$") 
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  public InternationalBankAccount iban(String iban) {
    this.iban = iban;
    return this;
  }

  /**
   * International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) 
   * @return iban
  */
  @ApiModelProperty(example = "GR1601101250000000012300695", value = "International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) ")

@Pattern(regexp = "^[A-Z0-9]{3,35}$") 
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public InternationalBankAccount bankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
    return this;
  }

  /**
   * Get bankDetails
   * @return bankDetails
  */
  @ApiModelProperty(value = "")

  @Valid

  public InternationalBankDetails getBankDetails() {
    return bankDetails;
  }

  public void setBankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
  }

  public InternationalBankAccount correspondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
    return this;
  }

  /**
   * Get correspondentBankAccount
   * @return correspondentBankAccount
  */
  @ApiModelProperty(value = "")

  @Valid

  public InternationalCorrespondentBankAccount getCorrespondentBankAccount() {
    return correspondentBankAccount;
  }

  public void setCorrespondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InternationalBankAccount internationalBankAccount = (InternationalBankAccount) o;
    return Objects.equals(this.number, internationalBankAccount.number) &&
        Objects.equals(this.iban, internationalBankAccount.iban) &&
        Objects.equals(this.bankDetails, internationalBankAccount.bankDetails) &&
        Objects.equals(this.correspondentBankAccount, internationalBankAccount.correspondentBankAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, iban, bankDetails, correspondentBankAccount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InternationalBankAccount {\n");
    
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    bankDetails: ").append(toIndentedString(bankDetails)).append("\n");
    sb.append("    correspondentBankAccount: ").append(toIndentedString(correspondentBankAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

