package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Категория чарджбэка
 */
public enum ChargebackCategory {
  
  FRAUD("fraud"),
  
  DISPUTE("dispute"),
  
  AUTHORISATION("authorisation"),
  
  PROCESSING_ERROR("processing_error");

  private String value;

  ChargebackCategory(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ChargebackCategory fromValue(String value) {
    for (ChargebackCategory b : ChargebackCategory.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

