package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.CashRangeAllOf;
import dev.vality.anapi.v2.model.InvoiceTemplateProductPrice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * CashRange
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public class CashRange extends InvoiceTemplateProductPrice  {
  @JsonProperty("upperBound")
  private Long upperBound;

  @JsonProperty("lowerBound")
  private Long lowerBound;

  @JsonProperty("currency")
  private String currency;

  public CashRange upperBound(Long upperBound) {
    this.upperBound = upperBound;
    return this;
  }

  /**
   * Верхняя (включительная) граница стоимости товаров или услуг.
   * minimum: 1
   * @return upperBound
  */
  @ApiModelProperty(required = true, value = "Верхняя (включительная) граница стоимости товаров или услуг.")
  @NotNull

@Min(1L) 
  public Long getUpperBound() {
    return upperBound;
  }

  public void setUpperBound(Long upperBound) {
    this.upperBound = upperBound;
  }

  public CashRange lowerBound(Long lowerBound) {
    this.lowerBound = lowerBound;
    return this;
  }

  /**
   * Нижняя (включительная) граница стоимости товаров или услуг.
   * minimum: 1
   * @return lowerBound
  */
  @ApiModelProperty(required = true, value = "Нижняя (включительная) граница стоимости товаров или услуг.")
  @NotNull

@Min(1L) 
  public Long getLowerBound() {
    return lowerBound;
  }

  public void setLowerBound(Long lowerBound) {
    this.lowerBound = lowerBound;
  }

  public CashRange currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CashRange cashRange = (CashRange) o;
    return Objects.equals(this.upperBound, cashRange.upperBound) &&
        Objects.equals(this.lowerBound, cashRange.lowerBound) &&
        Objects.equals(this.currency, cashRange.currency) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(upperBound, lowerBound, currency, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CashRange {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    upperBound: ").append(toIndentedString(upperBound)).append("\n");
    sb.append("    lowerBound: ").append(toIndentedString(lowerBound)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

