package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Платежная система
 */
public enum BankCardPaymentSystem {
  
  VISA("visa"),
  
  MASTERCARD("mastercard"),
  
  VISAELECTRON("visaelectron"),
  
  MAESTRO("maestro"),
  
  FORBRUGSFORENINGEN("forbrugsforeningen"),
  
  DANKORT("dankort"),
  
  AMEX("amex"),
  
  DINERSCLUB("dinersclub"),
  
  DISCOVER("discover"),
  
  UNIONPAY("unionpay"),
  
  JCB("jcb"),
  
  NSPKMIR("nspkmir"),
  
  ELO("elo"),
  
  RUPAY("rupay"),
  
  DUMMY("dummy"),
  
  UZCARD("uzcard");

  private String value;

  BankCardPaymentSystem(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BankCardPaymentSystem fromValue(String value) {
    for (BankCardPaymentSystem b : BankCardPaymentSystem.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

