package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse20010;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link RefundsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
public interface RefundsApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /refunds : Поиск возвратов
     * Поиск возвратов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param paymentID Идентификатор платежа в рамках инвойса (optional)
     * @param refundID Идентификатор возврата (optional)
     * @param refundStatus Статус возврата (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные возвраты (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see RefundsApi#searchRefunds
     */
    default ResponseEntity<InlineResponse20010> searchRefunds(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        String shopID,
        List<String> shopIDs,
        String paymentInstitutionRealm,
        String invoiceID,
        List<String> invoiceIDs,
        String paymentID,
        String refundID,
        String refundStatus,
        String externalID,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ], \"totalCount\" : 0, \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
