/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (5.3.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse2008;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-04-18T07:58:01.195848986Z[Etc/UTC]")
@Validated
@Api(value = "invoices", description = "the invoices API")
public interface InvoicesApi {

    default InvoicesApiDelegate getDelegate() {
        return new InvoicesApiDelegate() {};
    }

    /**
     * GET /invoices : Поиск инвойсов
     * Поиск инвойсов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param invoiceStatus Статус инвойса для поиска (optional)
     * @param invoiceAmountFrom Минимальная сумма инвойса (optional)
     * @param invoiceAmountTo Максимальная сумма инвойса (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные инвойсы (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Поиск инвойсов", nickname = "searchInvoices", notes = "Поиск инвойсов", response = InlineResponse2008.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Search", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Найденные инвойсы", response = InlineResponse2008.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = SearchRequestError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/invoices",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse2008> searchInvoices(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID

,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор инвойса") @Valid @RequestParam(value = "invoiceID", required = false) String invoiceID

,@ApiParam(value = "Список инвойсов") @Valid @RequestParam(value = "invoiceIDs", required = false) List<String> invoiceIDs

,@ApiParam(value = "Статус инвойса для поиска", allowableValues = "unpaid, cancelled, paid, fulfilled") @Valid @RequestParam(value = "invoiceStatus", required = false) String invoiceStatus

,@Min(1L) @ApiParam(value = "Минимальная сумма инвойса") @Valid @RequestParam(value = "invoiceAmountFrom", required = false) Long invoiceAmountFrom

,@Min(1L) @ApiParam(value = "Максимальная сумма инвойса") @Valid @RequestParam(value = "invoiceAmountTo", required = false) Long invoiceAmountTo

,@Size(min = 1, max = 40) @ApiParam(value = "Внешний идентификатор") @Valid @RequestParam(value = "externalID", required = false) String externalID

,@ApiParam(value = "") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken

) {
        return getDelegate().searchInvoices(xRequestID, partyID, fromTime, toTime, limit, xRequestDeadline, shopID, shopIDs, paymentInstitutionRealm, invoiceID, invoiceIDs, invoiceStatus, invoiceAmountFrom, invoiceAmountTo, externalID, continuationToken);
    }

}
