package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.SplitUnit;
import dev.vality.anapi.v2.model.StatusOffsetCount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * SplitCountResult
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class SplitCountResult   {
  @JsonProperty("splitUnit")
  private SplitUnit splitUnit;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("statusOffsetCounts")
  @Valid
  private List<StatusOffsetCount> statusOffsetCounts = new ArrayList<>();

  public SplitCountResult splitUnit(SplitUnit splitUnit) {
    this.splitUnit = splitUnit;
    return this;
  }

  /**
   * Get splitUnit
   * @return splitUnit
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public SplitUnit getSplitUnit() {
    return splitUnit;
  }

  public void setSplitUnit(SplitUnit splitUnit) {
    this.splitUnit = splitUnit;
  }

  public SplitCountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public SplitCountResult statusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
    return this;
  }

  public SplitCountResult addStatusOffsetCountsItem(StatusOffsetCount statusOffsetCountsItem) {
    this.statusOffsetCounts.add(statusOffsetCountsItem);
    return this;
  }

  /**
   * Get statusOffsetCounts
   * @return statusOffsetCounts
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<StatusOffsetCount> getStatusOffsetCounts() {
    return statusOffsetCounts;
  }

  public void setStatusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitCountResult splitCountResult = (SplitCountResult) o;
    return Objects.equals(this.splitUnit, splitCountResult.splitUnit) &&
        Objects.equals(this.currency, splitCountResult.currency) &&
        Objects.equals(this.statusOffsetCounts, splitCountResult.statusOffsetCounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(splitUnit, currency, statusOffsetCounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitCountResult {\n");
    
    sb.append("    splitUnit: ").append(toIndentedString(splitUnit)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    statusOffsetCounts: ").append(toIndentedString(statusOffsetCounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

