package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.Refund;
import dev.vality.anapi.v2.model.RefundSearchResultAllOf;
import dev.vality.anapi.v2.model.RefundStatusError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * RefundSearchResult
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class RefundSearchResult   {
  @JsonProperty("invoiceID")
  private String invoiceID;

  @JsonProperty("paymentID")
  private String paymentID;

  @JsonProperty("id")
  private String id;

  @JsonProperty("externalID")
  private String externalID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("reason")
  private String reason;

  @JsonProperty("shopID")
  private String shopID;

  /**
   * Статус возврата
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("error")
  private RefundStatusError error;

  public RefundSearchResult invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return invoiceID
  */
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public RefundSearchResult paymentID(String paymentID) {
    this.paymentID = paymentID;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return paymentID
  */
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getPaymentID() {
    return paymentID;
  }

  public void setPaymentID(String paymentID) {
    this.paymentID = paymentID;
  }

  public RefundSearchResult id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор возврата
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор возврата")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public RefundSearchResult externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  */
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public RefundSearchResult createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время осуществления
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время осуществления")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public RefundSearchResult amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public RefundSearchResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public RefundSearchResult reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Причина осуществления возврата
   * @return reason
  */
  @ApiModelProperty(value = "Причина осуществления возврата")


  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public RefundSearchResult shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public RefundSearchResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус возврата
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус возврата")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public RefundSearchResult error(RefundStatusError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  */
  @ApiModelProperty(value = "")

  @Valid

  public RefundStatusError getError() {
    return error;
  }

  public void setError(RefundStatusError error) {
    this.error = error;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundSearchResult refundSearchResult = (RefundSearchResult) o;
    return Objects.equals(this.invoiceID, refundSearchResult.invoiceID) &&
        Objects.equals(this.paymentID, refundSearchResult.paymentID) &&
        Objects.equals(this.id, refundSearchResult.id) &&
        Objects.equals(this.externalID, refundSearchResult.externalID) &&
        Objects.equals(this.createdAt, refundSearchResult.createdAt) &&
        Objects.equals(this.amount, refundSearchResult.amount) &&
        Objects.equals(this.currency, refundSearchResult.currency) &&
        Objects.equals(this.reason, refundSearchResult.reason) &&
        Objects.equals(this.shopID, refundSearchResult.shopID) &&
        Objects.equals(this.status, refundSearchResult.status) &&
        Objects.equals(this.error, refundSearchResult.error);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceID, paymentID, id, externalID, createdAt, amount, currency, reason, shopID, status, error);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundSearchResult {\n");
    
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    paymentID: ").append(toIndentedString(paymentID)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

