package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.BankAccount;
import dev.vality.anapi.v2.model.PayoutToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PayoutToolDetailsBankAccount
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class PayoutToolDetailsBankAccount extends PayoutToolDetails  {
  @JsonProperty("account")
  private String account;

  @JsonProperty("bankName")
  private String bankName;

  @JsonProperty("bankPostAccount")
  private String bankPostAccount;

  @JsonProperty("bankBik")
  private String bankBik;

  public PayoutToolDetailsBankAccount account(String account) {
    this.account = account;
    return this;
  }

  /**
   * Номер счёта
   * @return account
  */
  @ApiModelProperty(required = true, value = "Номер счёта")
  @NotNull

@Pattern(regexp = "^\\d{20}$") 
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public PayoutToolDetailsBankAccount bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

  /**
   * Наименование юридического лица банковской организации
   * @return bankName
  */
  @ApiModelProperty(required = true, value = "Наименование юридического лица банковской организации")
  @NotNull

@Size(max = 100) 
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public PayoutToolDetailsBankAccount bankPostAccount(String bankPostAccount) {
    this.bankPostAccount = bankPostAccount;
    return this;
  }

  /**
   * Get bankPostAccount
   * @return bankPostAccount
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

@Pattern(regexp = "^\\d{20}$") 
  public String getBankPostAccount() {
    return bankPostAccount;
  }

  public void setBankPostAccount(String bankPostAccount) {
    this.bankPostAccount = bankPostAccount;
  }

  public PayoutToolDetailsBankAccount bankBik(String bankBik) {
    this.bankBik = bankBik;
    return this;
  }

  /**
   * БИК банковской организации
   * @return bankBik
  */
  @ApiModelProperty(required = true, value = "БИК банковской организации")
  @NotNull

@Pattern(regexp = "^\\d{9}$") 
  public String getBankBik() {
    return bankBik;
  }

  public void setBankBik(String bankBik) {
    this.bankBik = bankBik;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutToolDetailsBankAccount payoutToolDetailsBankAccount = (PayoutToolDetailsBankAccount) o;
    return Objects.equals(this.account, payoutToolDetailsBankAccount.account) &&
        Objects.equals(this.bankName, payoutToolDetailsBankAccount.bankName) &&
        Objects.equals(this.bankPostAccount, payoutToolDetailsBankAccount.bankPostAccount) &&
        Objects.equals(this.bankBik, payoutToolDetailsBankAccount.bankBik) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(account, bankName, bankPostAccount, bankBik, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutToolDetailsBankAccount {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankPostAccount: ").append(toIndentedString(bankPostAccount)).append("\n");
    sb.append("    bankBik: ").append(toIndentedString(bankBik)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

