package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.PayoutToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Payout
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class Payout   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("shopID")
  private String shopID;

  @JsonProperty("createdAt")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  @JsonProperty("cancellationDetails")
  private String cancellationDetails;

  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("fee")
  private Long fee;

  @JsonProperty("currency")
  private String currency;

  @JsonProperty("payoutToolDetails")
  private PayoutToolDetails payoutToolDetails;

  @JsonProperty("status")
  private String status;

  @JsonProperty("metadata")
  private Object metadata;

  public Payout id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор выплаты
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор выплаты")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Payout shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  */
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Payout createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  */
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Payout cancellationDetails(String cancellationDetails) {
    this.cancellationDetails = cancellationDetails;
    return this;
  }

  /**
   * Детали отмены выплаты
   * @return cancellationDetails
  */
  @ApiModelProperty(value = "Детали отмены выплаты")

@Size(max = 1000) 
  public String getCancellationDetails() {
    return cancellationDetails;
  }

  public void setCancellationDetails(String cancellationDetails) {
    this.cancellationDetails = cancellationDetails;
  }

  public Payout amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Сумма выплаты в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "Сумма выплаты в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Payout fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  */
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")

@Min(0L) 
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Payout currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Payout payoutToolDetails(PayoutToolDetails payoutToolDetails) {
    this.payoutToolDetails = payoutToolDetails;
    return this;
  }

  /**
   * Get payoutToolDetails
   * @return payoutToolDetails
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PayoutToolDetails getPayoutToolDetails() {
    return payoutToolDetails;
  }

  public void setPayoutToolDetails(PayoutToolDetails payoutToolDetails) {
    this.payoutToolDetails = payoutToolDetails;
  }

  public Payout status(String status) {
    this.status = status;
    return this;
  }

  /**
   * Статус выплаты
   * @return status
  */
  @ApiModelProperty(value = "Статус выплаты")


  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Payout metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данной выплатой 
   * @return metadata
  */
  @ApiModelProperty(example = "{\"payoutDesc\":\"Custom payout\"}", value = "Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данной выплатой ")


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payout payout = (Payout) o;
    return Objects.equals(this.id, payout.id) &&
        Objects.equals(this.shopID, payout.shopID) &&
        Objects.equals(this.createdAt, payout.createdAt) &&
        Objects.equals(this.cancellationDetails, payout.cancellationDetails) &&
        Objects.equals(this.amount, payout.amount) &&
        Objects.equals(this.fee, payout.fee) &&
        Objects.equals(this.currency, payout.currency) &&
        Objects.equals(this.payoutToolDetails, payout.payoutToolDetails) &&
        Objects.equals(this.status, payout.status) &&
        Objects.equals(this.metadata, payout.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, shopID, createdAt, cancellationDetails, amount, fee, currency, payoutToolDetails, status, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payout {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    cancellationDetails: ").append(toIndentedString(cancellationDetails)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    payoutToolDetails: ").append(toIndentedString(payoutToolDetails)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

