package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Провайдер терминальной сети
 */
public enum PaymentTerminalProvider {
  
  EUROSET("euroset"),
  
  WECHAT("wechat"),
  
  ALIPAY("alipay"),
  
  ZOTAPAY("zotapay"),
  
  QPS("qps"),
  
  UZCARD("uzcard"),
  
  RBS("rbs");

  private String value;

  PaymentTerminalProvider(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PaymentTerminalProvider fromValue(String value) {
    for (PaymentTerminalProvider b : PaymentTerminalProvider.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

