package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.PaymentFlow;
import dev.vality.anapi.v2.model.PaymentFlowHoldAllOf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * PaymentFlowHold
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class PaymentFlowHold extends PaymentFlow  {
  /**
   * Политика управления удержанием денежных средств
   */
  public enum OnHoldExpirationEnum {
    CANCEL("cancel"),
    
    CAPTURE("capture");

    private String value;

    OnHoldExpirationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OnHoldExpirationEnum fromValue(String value) {
      for (OnHoldExpirationEnum b : OnHoldExpirationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("onHoldExpiration")
  private OnHoldExpirationEnum onHoldExpiration = OnHoldExpirationEnum.CANCEL;

  @JsonProperty("heldUntil")
  @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime heldUntil;

  public PaymentFlowHold onHoldExpiration(OnHoldExpirationEnum onHoldExpiration) {
    this.onHoldExpiration = onHoldExpiration;
    return this;
  }

  /**
   * Политика управления удержанием денежных средств
   * @return onHoldExpiration
  */
  @ApiModelProperty(required = true, value = "Политика управления удержанием денежных средств")
  @NotNull


  public OnHoldExpirationEnum getOnHoldExpiration() {
    return onHoldExpiration;
  }

  public void setOnHoldExpiration(OnHoldExpirationEnum onHoldExpiration) {
    this.onHoldExpiration = onHoldExpiration;
  }

  public PaymentFlowHold heldUntil(OffsetDateTime heldUntil) {
    this.heldUntil = heldUntil;
    return this;
  }

  /**
   * Дата и время, до которого происходит удержание денежных средств
   * @return heldUntil
  */
  @ApiModelProperty(value = "Дата и время, до которого происходит удержание денежных средств")

  @Valid

  public OffsetDateTime getHeldUntil() {
    return heldUntil;
  }

  public void setHeldUntil(OffsetDateTime heldUntil) {
    this.heldUntil = heldUntil;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentFlowHold paymentFlowHold = (PaymentFlowHold) o;
    return Objects.equals(this.onHoldExpiration, paymentFlowHold.onHoldExpiration) &&
        Objects.equals(this.heldUntil, paymentFlowHold.heldUntil) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(onHoldExpiration, heldUntil, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentFlowHold {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    onHoldExpiration: ").append(toIndentedString(onHoldExpiration)).append("\n");
    sb.append("    heldUntil: ").append(toIndentedString(heldUntil)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

