package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.SubError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * [Ошибка, возникшая в процессе проведения платежа](#tag/Error-Codes) 
 */
@ApiModel(description = "[Ошибка, возникшая в процессе проведения платежа](#tag/Error-Codes) ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class PaymentError   {
  @JsonProperty("code")
  private String code;

  @JsonProperty("subError")
  private SubError subError;

  public PaymentError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Основной код ошибки
   * @return code
  */
  @ApiModelProperty(required = true, value = "Основной код ошибки")
  @NotNull


  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public PaymentError subError(SubError subError) {
    this.subError = subError;
    return this;
  }

  /**
   * Get subError
   * @return subError
  */
  @ApiModelProperty(value = "")

  @Valid

  public SubError getSubError() {
    return subError;
  }

  public void setSubError(SubError subError) {
    this.subError = subError;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentError paymentError = (PaymentError) o;
    return Objects.equals(this.code, paymentError.code) &&
        Objects.equals(this.subError, paymentError.subError);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, subError);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentError {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    subError: ").append(toIndentedString(subError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

