package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.InvoiceTemplateProductPrice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * InvoiceTemplateProductAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class InvoiceTemplateProductAllOf   {
  @JsonProperty("product")
  private String product;

  @JsonProperty("price")
  private InvoiceTemplateProductPrice price;

  @JsonProperty("metadata")
  private Object metadata;

  public InvoiceTemplateProductAllOf product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  */
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  @NotNull

@Size(max = 1000) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceTemplateProductAllOf price(InvoiceTemplateProductPrice price) {
    this.price = price;
    return this;
  }

  /**
   * Get price
   * @return price
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public InvoiceTemplateProductPrice getPrice() {
    return price;
  }

  public void setPrice(InvoiceTemplateProductPrice price) {
    this.price = price;
  }

  public InvoiceTemplateProductAllOf metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с товарами или услугами метаданные
   * @return metadata
  */
  @ApiModelProperty(required = true, value = "Связанные с товарами или услугами метаданные")
  @NotNull


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceTemplateProductAllOf invoiceTemplateProductAllOf = (InvoiceTemplateProductAllOf) o;
    return Objects.equals(this.product, invoiceTemplateProductAllOf.product) &&
        Objects.equals(this.price, invoiceTemplateProductAllOf.price) &&
        Objects.equals(this.metadata, invoiceTemplateProductAllOf.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, price, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceTemplateProductAllOf {\n");
    
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

