package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.InvoiceLine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * InvoiceTemplateCartAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class InvoiceTemplateCartAllOf   {
  @JsonProperty("cart")
  @Valid
  private List<InvoiceLine> cart = new ArrayList<>();

  @JsonProperty("currency")
  private String currency;

  public InvoiceTemplateCartAllOf cart(List<InvoiceLine> cart) {
    this.cart = cart;
    return this;
  }

  public InvoiceTemplateCartAllOf addCartItem(InvoiceLine cartItem) {
    this.cart.add(cartItem);
    return this;
  }

  /**
   * Корзина с набором позиций продаваемых товаров или услуг 
   * @return cart
  */
  @ApiModelProperty(required = true, value = "Корзина с набором позиций продаваемых товаров или услуг ")
  @NotNull

  @Valid
@Size(min = 1, max = 100) 
  public List<InvoiceLine> getCart() {
    return cart;
  }

  public void setCart(List<InvoiceLine> cart) {
    this.cart = cart;
  }

  public InvoiceTemplateCartAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceTemplateCartAllOf invoiceTemplateCartAllOf = (InvoiceTemplateCartAllOf) o;
    return Objects.equals(this.cart, invoiceTemplateCartAllOf.cart) &&
        Objects.equals(this.currency, invoiceTemplateCartAllOf.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cart, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceTemplateCartAllOf {\n");
    
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

