package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.FileMetaSignatures;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * FileMeta
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class FileMeta   {
  @JsonProperty("id")
  private String id;

  @JsonProperty("filename")
  private String filename;

  @JsonProperty("signatures")
  private FileMetaSignatures signatures;

  public FileMeta id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор файла
   * @return id
  */
  @ApiModelProperty(required = true, value = "Идентификатор файла")
  @NotNull

@Size(min = 1, max = 40) 
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FileMeta filename(String filename) {
    this.filename = filename;
    return this;
  }

  /**
   * Имя файла
   * @return filename
  */
  @ApiModelProperty(required = true, value = "Имя файла")
  @NotNull

@Size(min = 1, max = 1000) 
  public String getFilename() {
    return filename;
  }

  public void setFilename(String filename) {
    this.filename = filename;
  }

  public FileMeta signatures(FileMetaSignatures signatures) {
    this.signatures = signatures;
    return this;
  }

  /**
   * Get signatures
   * @return signatures
  */
  @ApiModelProperty(value = "")

  @Valid

  public FileMetaSignatures getSignatures() {
    return signatures;
  }

  public void setSignatures(FileMetaSignatures signatures) {
    this.signatures = signatures;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileMeta fileMeta = (FileMeta) o;
    return Objects.equals(this.id, fileMeta.id) &&
        Objects.equals(this.filename, fileMeta.filename) &&
        Objects.equals(this.signatures, fileMeta.signatures);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, filename, signatures);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileMeta {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    signatures: ").append(toIndentedString(signatures)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

