package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные клиентского устройства плательщика
 */
@ApiModel(description = "Данные клиентского устройства плательщика")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class ClientInfo   {
  @JsonProperty("fingerprint")
  private String fingerprint;

  @JsonProperty("ip")
  private String ip;

  public ClientInfo fingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Уникальный отпечаток user agent'а плательщика
   * @return fingerprint
  */
  @ApiModelProperty(required = true, value = "Уникальный отпечаток user agent'а плательщика")
  @NotNull

@Size(max = 1000) 
  public String getFingerprint() {
    return fingerprint;
  }

  public void setFingerprint(String fingerprint) {
    this.fingerprint = fingerprint;
  }

  public ClientInfo ip(String ip) {
    this.ip = ip;
    return this;
  }

  /**
   * IP-адрес плательщика
   * @return ip
  */
  @ApiModelProperty(value = "IP-адрес плательщика")

@Size(max = 45) 
  public String getIp() {
    return ip;
  }

  public void setIp(String ip) {
    this.ip = ip;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientInfo clientInfo = (ClientInfo) o;
    return Objects.equals(this.fingerprint, clientInfo.fingerprint) &&
        Objects.equals(this.ip, clientInfo.ip);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fingerprint, ip);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientInfo {\n");
    
    sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

