package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * CashRangeAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class CashRangeAllOf   {
  @JsonProperty("upperBound")
  private Long upperBound;

  @JsonProperty("lowerBound")
  private Long lowerBound;

  @JsonProperty("currency")
  private String currency;

  public CashRangeAllOf upperBound(Long upperBound) {
    this.upperBound = upperBound;
    return this;
  }

  /**
   * Верхняя (включительная) граница стоимости товаров или услуг.
   * minimum: 1
   * @return upperBound
  */
  @ApiModelProperty(required = true, value = "Верхняя (включительная) граница стоимости товаров или услуг.")
  @NotNull

@Min(1L) 
  public Long getUpperBound() {
    return upperBound;
  }

  public void setUpperBound(Long upperBound) {
    this.upperBound = upperBound;
  }

  public CashRangeAllOf lowerBound(Long lowerBound) {
    this.lowerBound = lowerBound;
    return this;
  }

  /**
   * Нижняя (включительная) граница стоимости товаров или услуг.
   * minimum: 1
   * @return lowerBound
  */
  @ApiModelProperty(required = true, value = "Нижняя (включительная) граница стоимости товаров или услуг.")
  @NotNull

@Min(1L) 
  public Long getLowerBound() {
    return lowerBound;
  }

  public void setLowerBound(Long lowerBound) {
    this.lowerBound = lowerBound;
  }

  public CashRangeAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CashRangeAllOf cashRangeAllOf = (CashRangeAllOf) o;
    return Objects.equals(this.upperBound, cashRangeAllOf.upperBound) &&
        Objects.equals(this.lowerBound, cashRangeAllOf.lowerBound) &&
        Objects.equals(this.currency, cashRangeAllOf.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(upperBound, lowerBound, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CashRangeAllOf {\n");
    
    sb.append("    upperBound: ").append(toIndentedString(upperBound)).append("\n");
    sb.append("    lowerBound: ").append(toIndentedString(lowerBound)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

