package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * CashAllOf
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public class CashAllOf   {
  @JsonProperty("amount")
  private Long amount;

  @JsonProperty("currency")
  private String currency;

  public CashAllOf amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * minimum: 1
   * @return amount
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

@Min(1L) 
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public CashAllOf currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).
   * @return currency
  */
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
  @NotNull

@Pattern(regexp = "^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CashAllOf cashAllOf = (CashAllOf) o;
    return Objects.equals(this.amount, cashAllOf.amount) &&
        Objects.equals(this.currency, cashAllOf.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CashAllOf {\n");
    
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

