package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse20013;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link InvoiceTemplatesApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-02-21T10:55:49.751188903Z[Etc/UTC]")
public interface InvoiceTemplatesApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /invoice-templates : Поиск шаблонов инвойсов
     * Поиск шаблонов инвойсов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceTemplateID Идентификатор шаблона инвойса (optional)
     * @param invoiceTemplateStatus Статус шаблона инвойса для поиска (optional)
     * @param name Название шаблона инвойса (optional)
     * @param product Наименование товара или услуги (optional)
     * @param invoiceValidUntil Срок действия шаблона (optional)
     * @param continuationToken  (optional)
     * @return Найденные шаблоны инвойсов (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see InvoiceTemplatesApi#searchInvoiceTemplates
     */
    default ResponseEntity<InlineResponse20013> searchInvoiceTemplates(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        List<String> shopIDs,
        String paymentInstitutionRealm,
        String invoiceTemplateID,
        String invoiceTemplateStatus,
        String name,
        String product,
        OffsetDateTime invoiceValidUntil,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ], \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
