/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.anapi.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.anapi.v2.model.InvoiceLine;
import dev.vality.anapi.v2.model.InvoiceTemplateDetails;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class InvoiceTemplateCart
extends InvoiceTemplateDetails {
    @JsonProperty(value="cart")
    @Valid
    private List<InvoiceLine> cart = new ArrayList<InvoiceLine>();
    @JsonProperty(value="currency")
    private String currency;

    public InvoiceTemplateCart cart(List<InvoiceLine> cart) {
        this.cart = cart;
        return this;
    }

    public InvoiceTemplateCart addCartItem(InvoiceLine cartItem) {
        this.cart.add(cartItem);
        return this;
    }

    @ApiModelProperty(required=true, value="\u041a\u043e\u0440\u0437\u0438\u043d\u0430 \u0441 \u043d\u0430\u0431\u043e\u0440\u043e\u043c \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u043f\u0440\u043e\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433 ")
    @NotNull
    @Valid
    @Size(min=1, max=100)
    public @NotNull @Valid @Size(min=1, max=100) List<InvoiceLine> getCart() {
        return this.cart;
    }

    public void setCart(List<InvoiceLine> cart) {
        this.cart = cart;
    }

    public InvoiceTemplateCart currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public @NotNull @Pattern(regexp="^[A-Z]{3}$") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceTemplateCart invoiceTemplateCart = (InvoiceTemplateCart)o;
        return Objects.equals(this.cart, invoiceTemplateCart.cart) && Objects.equals(this.currency, invoiceTemplateCart.currency) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cart, this.currency, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceTemplateCart {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

