/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.api.ReportsApiDelegate;
import dev.vality.anapi.v2.model.DefaultLogicError;
import dev.vality.anapi.v2.model.GeneralError;
import dev.vality.anapi.v2.model.InlineResponse20014;
import dev.vality.anapi.v2.model.InlineResponse400;
import dev.vality.anapi.v2.model.InlineResponse4001;
import dev.vality.anapi.v2.model.Report;
import dev.vality.anapi.v2.model.ReportLink;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="reports", description="the reports API")
public interface ReportsApi {
    default public ReportsApiDelegate getDelegate() {
        return new ReportsApiDelegate(){};
    }

    @ApiOperation(value="\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442. \u041e\u0442\u0447\u0435\u0442\u044b \u0442\u0438\u043f\u0430 `provisionOfService` \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f", nickname="cancelReport", notes="\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442. \u041e\u0442\u0447\u0435\u0442\u044b \u0442\u0438\u043f\u0430 `provisionOfService` \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f", authorizations={@Authorization(value="bearer")}, tags={"Reports"})
    @ApiResponses(value={@ApiResponse(code=202, message="\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u0443 \u043e\u0442\u0447\u0435\u0442\u0430 \u043f\u0440\u0438\u043d\u044f\u0442"), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(method={RequestMethod.POST}, value={"/reports/{reportID}/cancel"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<Void> cancelReport(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0442\u0447\u0435\u0442\u0430", required=true) @PathVariable(value="reportID") Long reportID, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        return this.getDelegate().cancelReport(xRequestID, partyID, reportID, xRequestDeadline, paymentInstitutionRealm);
    }

    @ApiOperation(value="\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0442\u0438\u043f\u043e\u043c \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443 \u0437\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435\u043d\u0438", nickname="createReport", notes="\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0442\u0438\u043f\u043e\u043c \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443 \u0437\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a \u0432\u0440\u0435\u043c\u0435\u043d\u0438", response=Report.class, authorizations={@Authorization(value="bearer")}, tags={"Reports"})
    @ApiResponses(value={@ApiResponse(code=201, message="\u041e\u0442\u0447\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u043d", response=Report.class), @ApiResponse(code=400, message="\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438", response=InlineResponse4001.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(method={RequestMethod.POST}, value={"/reports"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<Report> createReport(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @NotNull @ApiParam(value="\u0422\u0438\u043f \u043e\u0442\u0447\u0435\u0442\u0430", required=true, allowableValues="paymentRegistry") @Valid @RequestParam(value="reportType", required=true) String reportType, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430") @Valid @RequestParam(value="shopID", required=false) @Size(min=1, max=40) @Valid String shopID, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        return this.getDelegate().createReport(xRequestID, partyID, fromTime, toTime, reportType, xRequestDeadline, shopID, paymentInstitutionRealm);
    }

    @ApiOperation(value="\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b", nickname="downloadFile", notes="\u0421\u043a\u0430\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b", response=ReportLink.class, authorizations={@Authorization(value="bearer")}, tags={"Reports"})
    @ApiResponses(value={@ApiResponse(code=200, message="Download link", response=ReportLink.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(method={RequestMethod.GET}, value={"/reports/{reportID}/files/{fileID}/download"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<ReportLink> downloadFile(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0442\u0447\u0435\u0442\u0430", required=true) @PathVariable(value="reportID") Long reportID, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0444\u0430\u0439\u043b\u0430", required=true) @PathVariable(value="fileID") @Size(min=1, max=40) String fileID, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        return this.getDelegate().downloadFile(xRequestID, partyID, reportID, fileID, xRequestDeadline, paymentInstitutionRealm);
    }

    @ApiOperation(value="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443", nickname="getReport", notes="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443", response=Report.class, authorizations={@Authorization(value="bearer")}, tags={"Reports"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0439 \u043e\u0442\u0447\u0435\u0442", response=Report.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(method={RequestMethod.GET}, value={"/reports/{reportID}"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<Report> getReport(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043e\u0442\u0447\u0435\u0442\u0430", required=true) @PathVariable(value="reportID") Long reportID, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        return this.getDelegate().getReport(xRequestID, partyID, reportID, xRequestDeadline, paymentInstitutionRealm);
    }

    @ApiOperation(value="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434", nickname="searchReports", notes="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434", response=InlineResponse20014.class, authorizations={@Authorization(value="bearer")}, tags={"Reports"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u043e\u0442\u0447\u0435\u0442\u044b", response=InlineResponse20014.class), @ApiResponse(code=400, message="\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f", response=InlineResponse400.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(method={RequestMethod.GET}, value={"/reports"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<InlineResponse20014> searchReports(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @NotNull @Min(value=1L) @Max(value=1000L) @ApiParam(value="\u041b\u0438\u043c\u0438\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0438", required=true) @Valid @RequestParam(value="limit", required=true) @NotNull @Min(value=1L) @Max(value=1000L) @Valid Integer limit, @NotNull @ApiParam(value="\u0422\u0438\u043f\u044b \u043e\u0442\u0447\u0435\u0442\u043e\u0432", required=true, allowableValues="provisionOfService, paymentRegistry, paymentRegistryByPayout") @Valid @RequestParam(value="reportTypes", required=true) List<String> reportTypes, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430") @Valid @RequestParam(value="shopID", required=false) @Size(min=1, max=40) @Valid String shopID, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm, @ApiParam(value="") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().searchReports(xRequestID, partyID, fromTime, toTime, limit, reportTypes, xRequestDeadline, shopID, paymentInstitutionRealm, continuationToken);
    }
}

