/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.api.PaymentsApiDelegate;
import dev.vality.anapi.v2.model.InlineResponse2009;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Api(value="payments", description="the payments API")
public interface PaymentsApi {
    default public PaymentsApiDelegate getDelegate() {
        return new PaymentsApiDelegate(){};
    }

    @ApiOperation(value="\u041f\u043e\u0438\u0441\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", nickname="searchPayments", notes="\u041f\u043e\u0438\u0441\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439", response=InlineResponse2009.class, authorizations={@Authorization(value="bearer")}, tags={"Search"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438", response=InlineResponse2009.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=SearchRequestError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438")})
    @RequestMapping(method={RequestMethod.GET}, value={"/payments"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<InlineResponse2009> searchPayments(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) @NotNull @Size(min=1, max=40) @Valid String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime, @NotNull @Min(value=1L) @Max(value=1000L) @ApiParam(value="\u041b\u0438\u043c\u0438\u0442 \u0432\u044b\u0431\u043e\u0440\u043a\u0438", required=true) @Valid @RequestParam(value="limit", required=true) @NotNull @Min(value=1L) @Max(value=1000L) @Valid Integer limit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430") @Valid @RequestParam(value="shopID", required=false) @Size(min=1, max=40) @Valid String shopID, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432, \u0438\u0441\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0445 \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="invoiceID", required=false) @Size(min=1, max=40) @Valid String invoiceID, @ApiParam(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u0432") @Valid @RequestParam(value="invoiceIDs", required=false) List<String> invoiceIDs, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0438\u043d\u0432\u043e\u0439\u0441\u0430") @Valid @RequestParam(value="paymentID", required=false) @Size(min=1, max=40) @Valid String paymentID, @ApiParam(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430", allowableValues="pending, processed, captured, cancelled, refunded, failed") @Valid @RequestParam(value="paymentStatus", required=false) String paymentStatus, @ApiParam(value="Flow \u043f\u043b\u0430\u0442\u0435\u0436\u0430", allowableValues="instant, hold") @Valid @RequestParam(value="paymentFlow", required=false) String paymentFlow, @ApiParam(value="\u041c\u0435\u0442\u043e\u0434 \u043e\u043f\u043b\u0430\u0442\u044b", allowableValues="bankCard, paymentTerminal") @Valid @RequestParam(value="paymentMethod", required=false) String paymentMethod, @ApiParam(value="\u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430", allowableValues="euroset, wechat, alipay, zotapay, qps, uzcard, rbs") @Valid @RequestParam(value="paymentTerminalProvider", required=false) String paymentTerminalProvider, @Size(max=100) @Email @ApiParam(value="Email, \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u0438 \u043e\u043f\u043b\u0430\u0442\u0435") @Valid @RequestParam(value="payerEmail", required=false) @Size(max=100) @Email @Valid String payerEmail, @Size(max=45) @ApiParam(value="IP-\u0430\u0434\u0440\u0435\u0441 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="payerIP", required=false) @Size(max=45) @Valid String payerIP, @Size(max=1000) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043e\u043a user agent'\u0430 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="payerFingerprint", required=false) @Size(max=1000) @Valid String payerFingerprint, @Size(min=1, max=40) @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u043b\u044c\u0449\u0438\u043a\u0430") @Valid @RequestParam(value="customerID", required=false) @Size(min=1, max=40) @Valid String customerID, @Pattern(regexp="^\\d{6}$") @ApiParam(value="\u041f\u0435\u0440\u0432\u044b\u0435 6 \u0446\u0438\u0444\u0440 \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442\u044b") @Valid @RequestParam(value="first6", required=false) @Pattern(regexp="^\\d{6}$") @Valid String first6, @Pattern(regexp="^\\d{4}$") @ApiParam(value="\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 4 \u0446\u0438\u0444\u0440\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u043a\u0430\u0440\u0442\u044b") @Valid @RequestParam(value="last4", required=false) @Pattern(regexp="^\\d{4}$") @Valid String last4, @Pattern(regexp="^[a-zA-Z0-9]{12}$") @ApiParam(value="Retrieval Reference Number") @Valid @RequestParam(value="rrn", required=false) @Pattern(regexp="^[a-zA-Z0-9]{12}$") @Valid String rrn, @Size(min=1, max=40) @ApiParam(value="Authorization Approval Code") @Valid @RequestParam(value="approvalCode", required=false) @Size(min=1, max=40) @Valid String approvalCode, @ApiParam(value="", allowableValues="applepay, googlepay, samsungpay, yandexpay") @Valid @RequestParam(value="bankCardTokenProvider", required=false) String bankCardTokenProvider, @ApiParam(value="", allowableValues="visa, mastercard, visaelectron, maestro, forbrugsforeningen, dankort, amex, dinersclub, discover, unionpay, jcb, nspkmir, elo, rupay, dummy, uzcard") @Valid @RequestParam(value="bankCardPaymentSystem", required=false) String bankCardPaymentSystem, @Min(value=1L) @ApiParam(value="\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430") @Valid @RequestParam(value="paymentAmountFrom", required=false) @Min(value=1L) @Valid Long paymentAmountFrom, @Min(value=1L) @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430") @Valid @RequestParam(value="paymentAmountTo", required=false) @Min(value=1L) @Valid Long paymentAmountTo, @Size(min=1, max=40) @ApiParam(value="\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440") @Valid @RequestParam(value="externalID", required=false) @Size(min=1, max=40) @Valid String externalID, @ApiParam(value="") @Valid @RequestParam(value="continuationToken", required=false) String continuationToken) {
        return this.getDelegate().searchPayments(xRequestID, partyID, fromTime, toTime, limit, xRequestDeadline, shopID, shopIDs, excludeShopIDs, paymentInstitutionRealm, invoiceID, invoiceIDs, paymentID, paymentStatus, paymentFlow, paymentMethod, paymentTerminalProvider, payerEmail, payerIP, payerFingerprint, customerID, first6, last4, rrn, approvalCode, bankCardTokenProvider, bankCardPaymentSystem, paymentAmountFrom, paymentAmountTo, externalID, continuationToken);
    }
}

