package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.anapi.v2.model.OffsetCount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * StatusOffsetCount
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
public class StatusOffsetCount   {
  /**
   * Статус платежа
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("offsetCount")
  @Valid
  private List<OffsetCount> offsetCount = new ArrayList<>();

  public StatusOffsetCount status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус платежа
   * @return status
  */
  @ApiModelProperty(required = true, value = "Статус платежа")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public StatusOffsetCount offsetCount(List<OffsetCount> offsetCount) {
    this.offsetCount = offsetCount;
    return this;
  }

  public StatusOffsetCount addOffsetCountItem(OffsetCount offsetCountItem) {
    this.offsetCount.add(offsetCountItem);
    return this;
  }

  /**
   * Get offsetCount
   * @return offsetCount
  */
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<OffsetCount> getOffsetCount() {
    return offsetCount;
  }

  public void setOffsetCount(List<OffsetCount> offsetCount) {
    this.offsetCount = offsetCount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StatusOffsetCount statusOffsetCount = (StatusOffsetCount) o;
    return Objects.equals(this.status, statusOffsetCount.status) &&
        Objects.equals(this.offsetCount, statusOffsetCount.offsetCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, offsetCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StatusOffsetCount {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    offsetCount: ").append(toIndentedString(offsetCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

