package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.anapi.v2.model.InvoiceLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Позиция товара или услуги
 */
@ApiModel(description = "Позиция товара или услуги")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
public class InvoiceLine   {
  @JsonProperty("product")
  private String product;

  @JsonProperty("quantity")
  private Long quantity = 1l;

  @JsonProperty("price")
  private Long price;

  @JsonProperty("cost")
  private Long cost;

  @JsonProperty("taxMode")
  private InvoiceLineTaxMode taxMode;

  public InvoiceLine product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Описание предлагаемого товара или услуги
   * @return product
  */
  @ApiModelProperty(required = true, value = "Описание предлагаемого товара или услуги")
  @NotNull

@Size(max = 1000) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceLine quantity(Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции 
   * minimum: 1
   * @return quantity
  */
  @ApiModelProperty(required = true, value = "Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции ")
  @NotNull

@Min(1L) 
  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public InvoiceLine price(Long price) {
    this.price = price;
    return this;
  }

  /**
   * Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты 
   * minimum: 1
   * @return price
  */
  @ApiModelProperty(required = true, value = "Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты ")
  @NotNull

@Min(1L) 
  public Long getPrice() {
    return price;
  }

  public void setPrice(Long price) {
    this.price = price;
  }

  public InvoiceLine cost(Long cost) {
    this.cost = cost;
    return this;
  }

  /**
   * Суммарная стоимость позиции с учётом количества единиц товаров или услуг 
   * minimum: 1
   * @return cost
  */
  @ApiModelProperty(value = "Суммарная стоимость позиции с учётом количества единиц товаров или услуг ")

@Min(1L) 
  public Long getCost() {
    return cost;
  }

  public void setCost(Long cost) {
    this.cost = cost;
  }

  public InvoiceLine taxMode(InvoiceLineTaxMode taxMode) {
    this.taxMode = taxMode;
    return this;
  }

  /**
   * Get taxMode
   * @return taxMode
  */
  @ApiModelProperty(value = "")

  @Valid

  public InvoiceLineTaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(InvoiceLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLine invoiceLine = (InvoiceLine) o;
    return Objects.equals(this.product, invoiceLine.product) &&
        Objects.equals(this.quantity, invoiceLine.quantity) &&
        Objects.equals(this.price, invoiceLine.price) &&
        Objects.equals(this.cost, invoiceLine.cost) &&
        Objects.equals(this.taxMode, invoiceLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLine {\n");
    
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

