package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Данные международной банковской организации
 */
@ApiModel(description = "Данные международной банковской организации")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
public class InternationalBankDetails   {
  @JsonProperty("bic")
  private String bic;

  @JsonProperty("abartn")
  private String abartn;

  @JsonProperty("name")
  private String name;

  @JsonProperty("countryCode")
  private String countryCode;

  @JsonProperty("address")
  private String address;

  public InternationalBankDetails bic(String bic) {
    this.bic = bic;
    return this;
  }

  /**
   * Business Identifier Code [ISO 9362](https://en.wikipedia.org/wiki/ISO_9362). 
   * @return bic
  */
  @ApiModelProperty(example = "RZBAATWW ", value = "Business Identifier Code [ISO 9362](https://en.wikipedia.org/wiki/ISO_9362). ")

@Pattern(regexp = "^([A-Z0-9]{8}|[A-Z0-9]{11})$") 
  public String getBic() {
    return bic;
  }

  public void setBic(String bic) {
    this.bic = bic;
  }

  public InternationalBankDetails abartn(String abartn) {
    this.abartn = abartn;
    return this;
  }

  /**
   * [ABA Routing Transit Number](https://en.wikipedia.org/wiki/ABA_routing_transit_number) банковской организации, специфичный для банковской системы USA. 
   * @return abartn
  */
  @ApiModelProperty(example = "129131673", value = "[ABA Routing Transit Number](https://en.wikipedia.org/wiki/ABA_routing_transit_number) банковской организации, специфичный для банковской системы USA. ")

@Pattern(regexp = "^[0-9]{9}$") 
  public String getAbartn() {
    return abartn;
  }

  public void setAbartn(String abartn) {
    this.abartn = abartn;
  }

  public InternationalBankDetails name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Наименование юридического лица банковской организации
   * @return name
  */
  @ApiModelProperty(example = "RAIFFEISEN BANK INTERNATIONAL AG ", value = "Наименование юридического лица банковской организации")

@Size(max = 100) 
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public InternationalBankDetails countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Get countryCode
   * @return countryCode
  */
  @ApiModelProperty(example = "AT", value = "")

@Pattern(regexp = "^[A-Z]{2}$") 
  public String getCountryCode() {
    return countryCode;
  }

  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  public InternationalBankDetails address(String address) {
    this.address = address;
    return this;
  }

  /**
   * Адрес юридического лица банковской организации
   * @return address
  */
  @ApiModelProperty(example = "1030, VIENNA, AM STADTPARK 9 ", value = "Адрес юридического лица банковской организации")

@Size(max = 1000) 
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InternationalBankDetails internationalBankDetails = (InternationalBankDetails) o;
    return Objects.equals(this.bic, internationalBankDetails.bic) &&
        Objects.equals(this.abartn, internationalBankDetails.abartn) &&
        Objects.equals(this.name, internationalBankDetails.name) &&
        Objects.equals(this.countryCode, internationalBankDetails.countryCode) &&
        Objects.equals(this.address, internationalBankDetails.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bic, abartn, name, countryCode, address);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InternationalBankDetails {\n");
    
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    abartn: ").append(toIndentedString(abartn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

