package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

/**
 * Сигнатуры файла
 */
@ApiModel(description = "Сигнатуры файла")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
public class FileMetaSignatures   {
  @JsonProperty("md5")
  private String md5;

  @JsonProperty("sha256")
  private String sha256;

  public FileMetaSignatures md5(String md5) {
    this.md5 = md5;
    return this;
  }

  /**
   * MD5 содержимого файла
   * @return md5
  */
  @ApiModelProperty(required = true, value = "MD5 содержимого файла")
  @NotNull

@Size(min = 32, max = 32) 
  public String getMd5() {
    return md5;
  }

  public void setMd5(String md5) {
    this.md5 = md5;
  }

  public FileMetaSignatures sha256(String sha256) {
    this.sha256 = sha256;
    return this;
  }

  /**
   * SHA256 содержимого файла
   * @return sha256
  */
  @ApiModelProperty(required = true, value = "SHA256 содержимого файла")
  @NotNull

@Size(min = 64, max = 64) 
  public String getSha256() {
    return sha256;
  }

  public void setSha256(String sha256) {
    this.sha256 = sha256;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileMetaSignatures fileMetaSignatures = (FileMetaSignatures) o;
    return Objects.equals(this.md5, fileMetaSignatures.md5) &&
        Objects.equals(this.sha256, fileMetaSignatures.sha256);
  }

  @Override
  public int hashCode() {
    return Objects.hash(md5, sha256);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileMetaSignatures {\n");
    
    sb.append("    md5: ").append(toIndentedString(md5)).append("\n");
    sb.append("    sha256: ").append(toIndentedString(sha256)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

