package dev.vality.anapi.v2.model;

import java.net.URI;
import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;


import java.util.*;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Провайдер платежных токенов
 */
public enum BankCardTokenProvider {
  
  APPLEPAY("applepay"),
  
  GOOGLEPAY("googlepay"),
  
  SAMSUNGPAY("samsungpay"),
  
  YANDEXPAY("yandexpay");

  private String value;

  BankCardTokenProvider(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BankCardTokenProvider fromValue(String value) {
    for (BankCardTokenProvider b : BankCardTokenProvider.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

