/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (5.3.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse20010;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
@Validated
@Api(value = "refunds", description = "the refunds API")
public interface RefundsApi {

    default RefundsApiDelegate getDelegate() {
        return new RefundsApiDelegate() {};
    }

    /**
     * GET /refunds : Поиск возвратов
     * Поиск возвратов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param paymentID Идентификатор платежа в рамках инвойса (optional)
     * @param refundID Идентификатор возврата (optional)
     * @param refundStatus Статус возврата (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные возвраты (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     */

    @ApiOperation(value = "Поиск возвратов", nickname = "searchRefunds", notes = "Поиск возвратов", response = InlineResponse20010.class, authorizations = {
        
        @Authorization(value = "bearer")
         }, tags={ "Search", })
    @ApiResponses(value = { 

        @ApiResponse(code = 200, message = "Найденные возвраты", response = InlineResponse20010.class),

        @ApiResponse(code = 400, message = "Неверные данные", response = SearchRequestError.class),

        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/refunds",
        produces = { "application/json; charset=utf-8" }
    )
    default ResponseEntity<InlineResponse20010> searchRefunds(
@ApiParam(value = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) String xRequestID
,@NotNull @Size(min = 1, max = 40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID

,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromTime

,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) @org.springframework.format.annotation.DateTimeFormat(iso = org.springframework.format.annotation.DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toTime

,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit

,
@ApiParam(value = "Максимальное время обработки запроса") @RequestHeader(value = "X-Request-Deadline", required = false) String xRequestDeadline
,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID

,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs

,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор инвойса") @Valid @RequestParam(value = "invoiceID", required = false) String invoiceID

,@ApiParam(value = "Список инвойсов") @Valid @RequestParam(value = "invoiceIDs", required = false) List<String> invoiceIDs

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор платежа в рамках инвойса") @Valid @RequestParam(value = "paymentID", required = false) String paymentID

,@Size(min = 1, max = 40) @ApiParam(value = "Идентификатор возврата") @Valid @RequestParam(value = "refundID", required = false) String refundID

,@ApiParam(value = "Статус возврата", allowableValues = "pending, succeeded, failed") @Valid @RequestParam(value = "refundStatus", required = false) String refundStatus

,@Size(min = 1, max = 40) @ApiParam(value = "Внешний идентификатор") @Valid @RequestParam(value = "externalID", required = false) String externalID

,@ApiParam(value = "") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken

) {
        return getDelegate().searchRefunds(xRequestID, partyID, fromTime, toTime, limit, xRequestDeadline, shopID, shopIDs, paymentInstitutionRealm, invoiceID, invoiceIDs, paymentID, refundID, refundStatus, externalID, continuationToken);
    }

}
