package dev.vality.anapi.v2.api;

import dev.vality.anapi.v2.model.InlineResponse2009;
import java.time.OffsetDateTime;
import dev.vality.anapi.v2.model.SearchRequestError;
import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * A delegate to be called by the {@link PaymentsApiController}}.
 * Implement this interface with a {@link org.springframework.stereotype.Service} annotated class.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-01-24T13:10:09.591965115Z[Etc/UTC]")
public interface PaymentsApiDelegate {

    default Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    /**
     * GET /payments : Поиск платежей
     * Поиск платежей
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param partyID Уникальный идентификатор участника в рамках платформы (required)
     * @param fromTime Начало временного отрезка (required)
     * @param toTime Конец временного отрезка (required)
     * @param limit Лимит выборки (required)
     * @param xRequestDeadline Максимальное время обработки запроса (optional)
     * @param shopID Идентификатор магазина (optional)
     * @param shopIDs Идентификаторы магазинов (optional)
     * @param excludeShopIDs Идентификаторы магазинов, исключаемых из запроса (optional)
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой» (optional)
     * @param invoiceID Идентификатор инвойса (optional)
     * @param invoiceIDs Список инвойсов (optional)
     * @param paymentID Идентификатор платежа в рамках инвойса (optional)
     * @param paymentStatus Статус платежа для поиска (optional)
     * @param paymentFlow Flow платежа (optional)
     * @param paymentMethod Метод оплаты (optional)
     * @param paymentTerminalProvider Провайдер платежного терминала (optional)
     * @param payerEmail Email, указанный при оплате (optional)
     * @param payerIP IP-адрес плательщика (optional)
     * @param payerFingerprint Уникальный отпечаток user agent&#39;а плательщика (optional)
     * @param customerID Идентификатор плательщика (optional)
     * @param first6 Первые 6 цифр номера карты (optional)
     * @param last4 Последние 4 цифры номера карты (optional)
     * @param rrn Retrieval Reference Number (optional)
     * @param approvalCode Authorization Approval Code (optional)
     * @param bankCardTokenProvider  (optional)
     * @param bankCardPaymentSystem  (optional)
     * @param paymentAmountFrom Минимальная сумма платежа (optional)
     * @param paymentAmountTo Максимальная сумма платежа (optional)
     * @param externalID Внешний идентификатор (optional)
     * @param continuationToken  (optional)
     * @return Найденные платежи (status code 200)
     *         or Неверные данные (status code 400)
     *         or Ошибка авторизации (status code 401)
     * @see PaymentsApi#searchPayments
     */
    default ResponseEntity<InlineResponse2009> searchPayments(String xRequestID,
        String partyID,
        OffsetDateTime fromTime,
        OffsetDateTime toTime,
        Integer limit,
        String xRequestDeadline,
        String shopID,
        List<String> shopIDs,
        List<String> excludeShopIDs,
        String paymentInstitutionRealm,
        String invoiceID,
        List<String> invoiceIDs,
        String paymentID,
        String paymentStatus,
        String paymentFlow,
        String paymentMethod,
        String paymentTerminalProvider,
        String payerEmail,
        String payerIP,
        String payerFingerprint,
        String customerID,
        String first6,
        String last4,
        String rrn,
        String approvalCode,
        String bankCardTokenProvider,
        String bankCardPaymentSystem,
        Long paymentAmountFrom,
        Long paymentAmountTo,
        String externalID,
        String continuationToken) {
        getRequest().ifPresent(request -> {
            for (MediaType mediaType: MediaType.parseMediaTypes(request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf("application/json; charset=utf-8"))) {
                    String exampleString = "{ \"result\" : [ null, null ], \"continuationToken\" : \"continuationToken\" }";
                    ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                    break;
                }
            }
        });
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);

    }

}
