/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.ApiClient;
import dev.vality.swag.analytics.model.InlineResponse20013;
import dev.vality.swag.analytics.model.Report;
import dev.vality.swag.analytics.model.ReportLink;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="dev.vality.swag.analytics.api.ReportsApi")
public class ReportsApi {
    private ApiClient apiClient;

    public ReportsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelReport(String xRequestID, Long reportID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling cancelReport");
        }
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling cancelReport");
        }
        HashMap<String, Long> uriVariables = new HashMap<String, Long>();
        uriVariables.put("reportID", reportID);
        String path = UriComponentsBuilder.fromPath((String)"/reports/{reportID}/cancel").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        if (xRequestDeadline != null) {
            headerParams.add("X-Request-Deadline", this.apiClient.parameterToString(xRequestDeadline));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>(){};
        this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public Report createReport(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String reportType, String xRequestDeadline, String shopID) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling createReport");
        }
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling createReport");
        }
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling createReport");
        }
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling createReport");
        }
        if (reportType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportType' when calling createReport");
        }
        String path = UriComponentsBuilder.fromPath((String)"/reports").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "reportType", reportType));
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        if (xRequestDeadline != null) {
            headerParams.add("X-Request-Deadline", this.apiClient.parameterToString(xRequestDeadline));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<Report> returnType = new ParameterizedTypeReference<Report>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ReportLink downloadFile(String xRequestID, Long reportID, String fileID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling downloadFile");
        }
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling downloadFile");
        }
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling downloadFile");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("reportID", reportID);
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath((String)"/reports/{reportID}/files/{fileID}/download").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        if (xRequestDeadline != null) {
            headerParams.add("X-Request-Deadline", this.apiClient.parameterToString(xRequestDeadline));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<ReportLink> returnType = new ParameterizedTypeReference<ReportLink>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public Report getReport(String xRequestID, Long reportID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getReport");
        }
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling getReport");
        }
        HashMap<String, Long> uriVariables = new HashMap<String, Long>();
        uriVariables.put("reportID", reportID);
        String path = UriComponentsBuilder.fromPath((String)"/reports/{reportID}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        if (xRequestDeadline != null) {
            headerParams.add("X-Request-Deadline", this.apiClient.parameterToString(xRequestDeadline));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<Report> returnType = new ParameterizedTypeReference<Report>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public InlineResponse20013 searchReports(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, List<String> reportTypes, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, Integer limit, String continuationToken) throws RestClientException {
        Object postBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchReports");
        }
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchReports");
        }
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchReports");
        }
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchReports");
        }
        if (reportTypes == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportTypes' when calling searchReports");
        }
        String path = UriComponentsBuilder.fromPath((String)"/reports").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "reportTypes", reportTypes));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        if (xRequestID != null) {
            headerParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        if (xRequestDeadline != null) {
            headerParams.add("X-Request-Deadline", this.apiClient.parameterToString(xRequestDeadline));
        }
        String[] accepts = new String[]{"application/json; charset=utf-8"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"application/json; charset=utf-8"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"bearer"};
        ParameterizedTypeReference<InlineResponse20013> returnType = new ParameterizedTypeReference<InlineResponse20013>(){};
        return this.apiClient.invokeAPI(path, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

