/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.StatusOffsetCount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * SplitCountResult
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class SplitCountResult {
  /**
   * Единица времени сегмента разбиения
   */
  public enum SplitUnitEnum {
    MINUTE("minute"),
    
    HOUR("hour"),
    
    DAY("day"),
    
    WEEK("week"),
    
    MONTH("month"),
    
    YEAR("year");

    private String value;

    SplitUnitEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SplitUnitEnum fromValue(String text) {
      for (SplitUnitEnum b : SplitUnitEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("splitUnit")
  private SplitUnitEnum splitUnit = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("statusOffsetCounts")
  private List<StatusOffsetCount> statusOffsetCounts = new ArrayList<>();

  public SplitCountResult splitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
    return this;
  }

   /**
   * Единица времени сегмента разбиения
   * @return splitUnit
  **/
  @ApiModelProperty(required = true, value = "Единица времени сегмента разбиения")
  public SplitUnitEnum getSplitUnit() {
    return splitUnit;
  }

  public void setSplitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
  }

  public SplitCountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public SplitCountResult statusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
    return this;
  }

  public SplitCountResult addStatusOffsetCountsItem(StatusOffsetCount statusOffsetCountsItem) {
    this.statusOffsetCounts.add(statusOffsetCountsItem);
    return this;
  }

   /**
   * Get statusOffsetCounts
   * @return statusOffsetCounts
  **/
  @ApiModelProperty(required = true, value = "")
  public List<StatusOffsetCount> getStatusOffsetCounts() {
    return statusOffsetCounts;
  }

  public void setStatusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitCountResult splitCountResult = (SplitCountResult) o;
    return Objects.equals(this.splitUnit, splitCountResult.splitUnit) &&
        Objects.equals(this.currency, splitCountResult.currency) &&
        Objects.equals(this.statusOffsetCounts, splitCountResult.statusOffsetCounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(splitUnit, currency, statusOffsetCounts);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitCountResult {\n");
    
    sb.append("    splitUnit: ").append(toIndentedString(splitUnit)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    statusOffsetCounts: ").append(toIndentedString(statusOffsetCounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

