/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.ShopAccount;
import dev.vality.swag.analytics.model.ShopDetails;
import dev.vality.swag.analytics.model.ShopLocation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * Данные магазина
 */
@ApiModel(description = "Данные магазина")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class Shop {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("isBlocked")
  private Boolean isBlocked = null;

  @JsonProperty("isSuspended")
  private Boolean isSuspended = null;

  @JsonProperty("categoryID")
  private Integer categoryID = null;

  @JsonProperty("location")
  private ShopLocation location = null;

  @JsonProperty("details")
  private ShopDetails details = null;

  @JsonProperty("contractID")
  private String contractID = null;

  @JsonProperty("payoutToolID")
  private String payoutToolID = null;

  @JsonProperty("scheduleID")
  private Integer scheduleID = null;

  @JsonProperty("account")
  private ShopAccount account = null;

  public Shop id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Идентификатор магазина
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Shop createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Shop isBlocked(Boolean isBlocked) {
    this.isBlocked = isBlocked;
    return this;
  }

   /**
   * Заблокирован ли магазин?
   * @return isBlocked
  **/
  @ApiModelProperty(required = true, value = "Заблокирован ли магазин?")
  public Boolean isIsBlocked() {
    return isBlocked;
  }

  public void setIsBlocked(Boolean isBlocked) {
    this.isBlocked = isBlocked;
  }

  public Shop isSuspended(Boolean isSuspended) {
    this.isSuspended = isSuspended;
    return this;
  }

   /**
   * Приостановлены ли операции в рамках магазина?
   * @return isSuspended
  **/
  @ApiModelProperty(required = true, value = "Приостановлены ли операции в рамках магазина?")
  public Boolean isIsSuspended() {
    return isSuspended;
  }

  public void setIsSuspended(Boolean isSuspended) {
    this.isSuspended = isSuspended;
  }

  public Shop categoryID(Integer categoryID) {
    this.categoryID = categoryID;
    return this;
  }

   /**
   * Идентификатор категории товаров и услуг, предлагаемых в этом магазине 
   * @return categoryID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор категории товаров и услуг, предлагаемых в этом магазине ")
  public Integer getCategoryID() {
    return categoryID;
  }

  public void setCategoryID(Integer categoryID) {
    this.categoryID = categoryID;
  }

  public Shop location(ShopLocation location) {
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(required = true, value = "")
  public ShopLocation getLocation() {
    return location;
  }

  public void setLocation(ShopLocation location) {
    this.location = location;
  }

  public Shop details(ShopDetails details) {
    this.details = details;
    return this;
  }

   /**
   * Get details
   * @return details
  **/
  @ApiModelProperty(required = true, value = "")
  public ShopDetails getDetails() {
    return details;
  }

  public void setDetails(ShopDetails details) {
    this.details = details;
  }

  public Shop contractID(String contractID) {
    this.contractID = contractID;
    return this;
  }

   /**
   * Идентификатор договора, на основании которого производится обслуживание магазина 
   * @return contractID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор договора, на основании которого производится обслуживание магазина ")
  public String getContractID() {
    return contractID;
  }

  public void setContractID(String contractID) {
    this.contractID = contractID;
  }

  public Shop payoutToolID(String payoutToolID) {
    this.payoutToolID = payoutToolID;
    return this;
  }

   /**
   * Идентификатор средства вывода в рамках контракта, используемое в процессе вывода по магазину 
   * @return payoutToolID
  **/
  @ApiModelProperty(value = "Идентификатор средства вывода в рамках контракта, используемое в процессе вывода по магазину ")
  public String getPayoutToolID() {
    return payoutToolID;
  }

  public void setPayoutToolID(String payoutToolID) {
    this.payoutToolID = payoutToolID;
  }

  public Shop scheduleID(Integer scheduleID) {
    this.scheduleID = scheduleID;
    return this;
  }

   /**
   * Идентификатор расписания выводов
   * @return scheduleID
  **/
  @ApiModelProperty(value = "Идентификатор расписания выводов")
  public Integer getScheduleID() {
    return scheduleID;
  }

  public void setScheduleID(Integer scheduleID) {
    this.scheduleID = scheduleID;
  }

  public Shop account(ShopAccount account) {
    this.account = account;
    return this;
  }

   /**
   * Get account
   * @return account
  **/
  @ApiModelProperty(value = "")
  public ShopAccount getAccount() {
    return account;
  }

  public void setAccount(ShopAccount account) {
    this.account = account;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Shop shop = (Shop) o;
    return Objects.equals(this.id, shop.id) &&
        Objects.equals(this.createdAt, shop.createdAt) &&
        Objects.equals(this.isBlocked, shop.isBlocked) &&
        Objects.equals(this.isSuspended, shop.isSuspended) &&
        Objects.equals(this.categoryID, shop.categoryID) &&
        Objects.equals(this.location, shop.location) &&
        Objects.equals(this.details, shop.details) &&
        Objects.equals(this.contractID, shop.contractID) &&
        Objects.equals(this.payoutToolID, shop.payoutToolID) &&
        Objects.equals(this.scheduleID, shop.scheduleID) &&
        Objects.equals(this.account, shop.account);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, isBlocked, isSuspended, categoryID, location, details, contractID, payoutToolID, scheduleID, account);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Shop {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    isBlocked: ").append(toIndentedString(isBlocked)).append("\n");
    sb.append("    isSuspended: ").append(toIndentedString(isSuspended)).append("\n");
    sb.append("    categoryID: ").append(toIndentedString(categoryID)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    contractID: ").append(toIndentedString(contractID)).append("\n");
    sb.append("    payoutToolID: ").append(toIndentedString(payoutToolID)).append("\n");
    sb.append("    scheduleID: ").append(toIndentedString(scheduleID)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

