/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.PayoutToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * Payout
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class Payout {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("cancellationDetails")
  private String cancellationDetails = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("fee")
  private Long fee = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("payoutToolDetails")
  private PayoutToolDetails payoutToolDetails = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  public Payout id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Идентификатор выплаты
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор выплаты")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Payout shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

   /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Payout createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Payout cancellationDetails(String cancellationDetails) {
    this.cancellationDetails = cancellationDetails;
    return this;
  }

   /**
   * Детали отмены выплаты
   * @return cancellationDetails
  **/
  @ApiModelProperty(value = "Детали отмены выплаты")
  public String getCancellationDetails() {
    return cancellationDetails;
  }

  public void setCancellationDetails(String cancellationDetails) {
    this.cancellationDetails = cancellationDetails;
  }

  public Payout amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Сумма выплаты в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Сумма выплаты в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Payout fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  **/
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Payout currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Payout payoutToolDetails(PayoutToolDetails payoutToolDetails) {
    this.payoutToolDetails = payoutToolDetails;
    return this;
  }

   /**
   * Get payoutToolDetails
   * @return payoutToolDetails
  **/
  @ApiModelProperty(required = true, value = "")
  public PayoutToolDetails getPayoutToolDetails() {
    return payoutToolDetails;
  }

  public void setPayoutToolDetails(PayoutToolDetails payoutToolDetails) {
    this.payoutToolDetails = payoutToolDetails;
  }

  public Payout status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Статус выплаты
   * @return status
  **/
  @ApiModelProperty(value = "Статус выплаты")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Payout metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данной выплатой 
   * @return metadata
  **/
  @ApiModelProperty(example = "{\"payoutDesc\":\"Custom payout\"}", value = "Произвольный, специфичный для клиента API и непрозрачный для системы набор данных, ассоциированных с данной выплатой ")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payout payout = (Payout) o;
    return Objects.equals(this.id, payout.id) &&
        Objects.equals(this.shopID, payout.shopID) &&
        Objects.equals(this.createdAt, payout.createdAt) &&
        Objects.equals(this.cancellationDetails, payout.cancellationDetails) &&
        Objects.equals(this.amount, payout.amount) &&
        Objects.equals(this.fee, payout.fee) &&
        Objects.equals(this.currency, payout.currency) &&
        Objects.equals(this.payoutToolDetails, payout.payoutToolDetails) &&
        Objects.equals(this.status, payout.status) &&
        Objects.equals(this.metadata, payout.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, shopID, createdAt, cancellationDetails, amount, fee, currency, payoutToolDetails, status, metadata);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payout {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    cancellationDetails: ").append(toIndentedString(cancellationDetails)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    payoutToolDetails: ").append(toIndentedString(payoutToolDetails)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

