/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.BankCardDetails;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * PaymentToolDetailsBankCard
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class PaymentToolDetailsBankCard extends PaymentToolDetails {
  @JsonProperty("cardNumberMask")
  private String cardNumberMask = null;

  @JsonProperty("bin")
  private String bin = null;

  @JsonProperty("lastDigits")
  private String lastDigits = null;

  /**
   * Платежная система
   */
  public enum PaymentSystemEnum {
    VISA("visa"),
    
    MASTERCARD("mastercard"),
    
    VISAELECTRON("visaelectron"),
    
    MAESTRO("maestro"),
    
    FORBRUGSFORENINGEN("forbrugsforeningen"),
    
    DANKORT("dankort"),
    
    AMEX("amex"),
    
    DINERSCLUB("dinersclub"),
    
    DISCOVER("discover"),
    
    UNIONPAY("unionpay"),
    
    JCB("jcb"),
    
    NSPKMIR("nspkmir"),
    
    ELO("elo"),
    
    RUPAY("rupay"),
    
    DUMMY("dummy"),
    
    UZCARD("uzcard");

    private String value;

    PaymentSystemEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentSystemEnum fromValue(String text) {
      for (PaymentSystemEnum b : PaymentSystemEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("paymentSystem")
  private PaymentSystemEnum paymentSystem = null;

  /**
   * Провайдер платежных токенов
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String text) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("tokenProvider")
  private TokenProviderEnum tokenProvider = null;

  public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

   /**
   * Маскированый номер карты
   * @return cardNumberMask
  **/
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public PaymentToolDetailsBankCard bin(String bin) {
    this.bin = bin;
    return this;
  }

   /**
   * BIN банка-эмитента карты
   * @return bin
  **/
  @ApiModelProperty(value = "BIN банка-эмитента карты")
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

   /**
   * Последние цифры номера карты
   * @return lastDigits
  **/
  @ApiModelProperty(value = "Последние цифры номера карты")
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public PaymentToolDetailsBankCard paymentSystem(PaymentSystemEnum paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

   /**
   * Платежная система
   * @return paymentSystem
  **/
  @ApiModelProperty(required = true, value = "Платежная система")
  public PaymentSystemEnum getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(PaymentSystemEnum paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

   /**
   * Провайдер платежных токенов
   * @return tokenProvider
  **/
  @ApiModelProperty(value = "Провайдер платежных токенов")
  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard) o;
    return Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) &&
        Objects.equals(this.bin, paymentToolDetailsBankCard.bin) &&
        Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, paymentToolDetailsBankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsBankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

