/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InvoiceLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Позиция товара или услуги
 */
@ApiModel(description = "Позиция товара или услуги")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class InvoiceLine {
  @JsonProperty("product")
  private String product = null;

  @JsonProperty("quantity")
  private Long quantity = 1l;

  @JsonProperty("price")
  private Long price = null;

  @JsonProperty("cost")
  private Long cost = null;

  @JsonProperty("taxMode")
  private InvoiceLineTaxMode taxMode = null;

  public InvoiceLine product(String product) {
    this.product = product;
    return this;
  }

   /**
   * Описание предлагаемого товара или услуги
   * @return product
  **/
  @ApiModelProperty(required = true, value = "Описание предлагаемого товара или услуги")
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public InvoiceLine quantity(Long quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции 
   * minimum: 1
   * @return quantity
  **/
  @ApiModelProperty(required = true, value = "Количество единиц товаров или услуг, предлагаемых на продажу в этой позиции ")
  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public InvoiceLine price(Long price) {
    this.price = price;
    return this;
  }

   /**
   * Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты 
   * minimum: 1
   * @return price
  **/
  @ApiModelProperty(required = true, value = "Цена предлагаемого товара или услуги, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты ")
  public Long getPrice() {
    return price;
  }

  public void setPrice(Long price) {
    this.price = price;
  }

  public InvoiceLine cost(Long cost) {
    this.cost = cost;
    return this;
  }

   /**
   * Суммарная стоимость позиции с учётом количества единиц товаров или услуг 
   * minimum: 1
   * @return cost
  **/
  @ApiModelProperty(value = "Суммарная стоимость позиции с учётом количества единиц товаров или услуг ")
  public Long getCost() {
    return cost;
  }

  public void setCost(Long cost) {
    this.cost = cost;
  }

  public InvoiceLine taxMode(InvoiceLineTaxMode taxMode) {
    this.taxMode = taxMode;
    return this;
  }

   /**
   * Get taxMode
   * @return taxMode
  **/
  @ApiModelProperty(value = "")
  public InvoiceLineTaxMode getTaxMode() {
    return taxMode;
  }

  public void setTaxMode(InvoiceLineTaxMode taxMode) {
    this.taxMode = taxMode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLine invoiceLine = (InvoiceLine) o;
    return Objects.equals(this.product, invoiceLine.product) &&
        Objects.equals(this.quantity, invoiceLine.quantity) &&
        Objects.equals(this.price, invoiceLine.price) &&
        Objects.equals(this.cost, invoiceLine.cost) &&
        Objects.equals(this.taxMode, invoiceLine.taxMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, quantity, price, cost, taxMode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLine {\n");
    
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    taxMode: ").append(toIndentedString(taxMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

