/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InvoiceCart;
import dev.vality.swag.analytics.model.InvoiceStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * Invoice
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class Invoice {
  /**
   * Статус инвойса
   */
  public enum StatusEnum {
    UNPAID("unpaid"),
    
    CANCELLED("cancelled"),
    
    PAID("paid"),
    
    FULFILLED("fulfilled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("externalID")
  private String externalID = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("dueDate")
  private OffsetDateTime dueDate = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("product")
  private String product = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("invoiceTemplateID")
  private String invoiceTemplateID = null;

  @JsonProperty("cart")
  private InvoiceCart cart = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  public Invoice status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Статус инвойса
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус инвойса")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Invoice reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Причина отмены или погашения инвойса
   * @return reason
  **/
  @ApiModelProperty(value = "Причина отмены или погашения инвойса")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public Invoice id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Идентификатор инвойса
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Invoice externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

   /**
   * Внешний идентификатор
   * @return externalID
  **/
  @ApiModelProperty(value = "Внешний идентификатор")
  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public Invoice shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

   /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Invoice createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Invoice dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

   /**
   * Дата и время окончания действия
   * @return dueDate
  **/
  @ApiModelProperty(required = true, value = "Дата и время окончания действия")
  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public Invoice amount(Long amount) {
    this.amount = amount;
    return this;
  }

   /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Invoice currency(String currency) {
    this.currency = currency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Invoice product(String product) {
    this.product = product;
    return this;
  }

   /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  **/
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public Invoice description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Описание предлагаемых товаров или услуг
   * @return description
  **/
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Invoice invoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
    return this;
  }

   /**
   * Идентификатор шаблона (для инвойсов, созданных по шаблону).
   * @return invoiceTemplateID
  **/
  @ApiModelProperty(value = "Идентификатор шаблона (для инвойсов, созданных по шаблону).")
  public String getInvoiceTemplateID() {
    return invoiceTemplateID;
  }

  public void setInvoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
  }

  public Invoice cart(InvoiceCart cart) {
    this.cart = cart;
    return this;
  }

   /**
   * Get cart
   * @return cart
  **/
  @ApiModelProperty(value = "")
  public InvoiceCart getCart() {
    return cart;
  }

  public void setCart(InvoiceCart cart) {
    this.cart = cart;
  }

  public Invoice metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

   /**
   * Связанные с инвойсом метаданные
   * @return metadata
  **/
  @ApiModelProperty(required = true, value = "Связанные с инвойсом метаданные")
  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoice invoice = (Invoice) o;
    return Objects.equals(this.status, invoice.status) &&
        Objects.equals(this.reason, invoice.reason) &&
        Objects.equals(this.id, invoice.id) &&
        Objects.equals(this.externalID, invoice.externalID) &&
        Objects.equals(this.shopID, invoice.shopID) &&
        Objects.equals(this.createdAt, invoice.createdAt) &&
        Objects.equals(this.dueDate, invoice.dueDate) &&
        Objects.equals(this.amount, invoice.amount) &&
        Objects.equals(this.currency, invoice.currency) &&
        Objects.equals(this.product, invoice.product) &&
        Objects.equals(this.description, invoice.description) &&
        Objects.equals(this.invoiceTemplateID, invoice.invoiceTemplateID) &&
        Objects.equals(this.cart, invoice.cart) &&
        Objects.equals(this.metadata, invoice.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, reason, id, externalID, shopID, createdAt, dueDate, amount, currency, product, description, invoiceTemplateID, cart, metadata);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoice {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    invoiceTemplateID: ").append(toIndentedString(invoiceTemplateID)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

