/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InternationalBankAccount;
import dev.vality.swag.analytics.model.InternationalBankDetails;
import dev.vality.swag.analytics.model.InternationalCorrespondentBankAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * InternationalCorrespondentBankAccount
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class InternationalCorrespondentBankAccount {
  @JsonProperty("number")
  private String number = null;

  @JsonProperty("iban")
  private String iban = null;

  @JsonProperty("bankDetails")
  private InternationalBankDetails bankDetails = null;

  @JsonProperty("correspondentBankAccount")
  private InternationalCorrespondentBankAccount correspondentBankAccount = null;

  public InternationalCorrespondentBankAccount number(String number) {
    this.number = number;
    return this;
  }

   /**
   * Номер счёта 
   * @return number
  **/
  @ApiModelProperty(example = "123006951", value = "Номер счёта ")
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  public InternationalCorrespondentBankAccount iban(String iban) {
    this.iban = iban;
    return this;
  }

   /**
   * International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) 
   * @return iban
  **/
  @ApiModelProperty(example = "GR1601101250000000012300695", value = "International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) ")
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public InternationalCorrespondentBankAccount bankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
    return this;
  }

   /**
   * Get bankDetails
   * @return bankDetails
  **/
  @ApiModelProperty(value = "")
  public InternationalBankDetails getBankDetails() {
    return bankDetails;
  }

  public void setBankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
  }

  public InternationalCorrespondentBankAccount correspondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
    return this;
  }

   /**
   * Get correspondentBankAccount
   * @return correspondentBankAccount
  **/
  @ApiModelProperty(value = "")
  public InternationalCorrespondentBankAccount getCorrespondentBankAccount() {
    return correspondentBankAccount;
  }

  public void setCorrespondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InternationalCorrespondentBankAccount internationalCorrespondentBankAccount = (InternationalCorrespondentBankAccount) o;
    return Objects.equals(this.number, internationalCorrespondentBankAccount.number) &&
        Objects.equals(this.iban, internationalCorrespondentBankAccount.iban) &&
        Objects.equals(this.bankDetails, internationalCorrespondentBankAccount.bankDetails) &&
        Objects.equals(this.correspondentBankAccount, internationalCorrespondentBankAccount.correspondentBankAccount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, iban, bankDetails, correspondentBankAccount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InternationalCorrespondentBankAccount {\n");
    
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    bankDetails: ").append(toIndentedString(bankDetails)).append("\n");
    sb.append("    correspondentBankAccount: ").append(toIndentedString(correspondentBankAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

