/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Данные международной банковской организации
 */
@ApiModel(description = "Данные международной банковской организации")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class InternationalBankDetails {
  @JsonProperty("bic")
  private String bic = null;

  @JsonProperty("abartn")
  private String abartn = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("countryCode")
  private String countryCode = null;

  @JsonProperty("address")
  private String address = null;

  public InternationalBankDetails bic(String bic) {
    this.bic = bic;
    return this;
  }

   /**
   * Business Identifier Code [ISO 9362](https://en.wikipedia.org/wiki/ISO_9362). 
   * @return bic
  **/
  @ApiModelProperty(example = "RZBAATWW ", value = "Business Identifier Code [ISO 9362](https://en.wikipedia.org/wiki/ISO_9362). ")
  public String getBic() {
    return bic;
  }

  public void setBic(String bic) {
    this.bic = bic;
  }

  public InternationalBankDetails abartn(String abartn) {
    this.abartn = abartn;
    return this;
  }

   /**
   * [ABA Routing Transit Number](https://en.wikipedia.org/wiki/ABA_routing_transit_number) банковской организации, специфичный для банковской системы USA. 
   * @return abartn
  **/
  @ApiModelProperty(example = "129131673", value = "[ABA Routing Transit Number](https://en.wikipedia.org/wiki/ABA_routing_transit_number) банковской организации, специфичный для банковской системы USA. ")
  public String getAbartn() {
    return abartn;
  }

  public void setAbartn(String abartn) {
    this.abartn = abartn;
  }

  public InternationalBankDetails name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Наименование юридического лица банковской организации
   * @return name
  **/
  @ApiModelProperty(example = "RAIFFEISEN BANK INTERNATIONAL AG ", value = "Наименование юридического лица банковской организации")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public InternationalBankDetails countryCode(String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Страна резиденции банковской организации, alpha-3 код по стандарту [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1) 
   * @return countryCode
  **/
  @ApiModelProperty(example = "RUS", value = "Страна резиденции банковской организации, alpha-3 код по стандарту [ISO 3166-1](https://en.wikipedia.org/wiki/ISO_3166-1) ")
  public String getCountryCode() {
    return countryCode;
  }

  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }

  public InternationalBankDetails address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Адрес юридического лица банковской организации
   * @return address
  **/
  @ApiModelProperty(example = "1030, VIENNA, AM STADTPARK 9 ", value = "Адрес юридического лица банковской организации")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InternationalBankDetails internationalBankDetails = (InternationalBankDetails) o;
    return Objects.equals(this.bic, internationalBankDetails.bic) &&
        Objects.equals(this.abartn, internationalBankDetails.abartn) &&
        Objects.equals(this.name, internationalBankDetails.name) &&
        Objects.equals(this.countryCode, internationalBankDetails.countryCode) &&
        Objects.equals(this.address, internationalBankDetails.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bic, abartn, name, countryCode, address);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InternationalBankDetails {\n");
    
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    abartn: ").append(toIndentedString(abartn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

