/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Сигнатуры файла
 */
@ApiModel(description = "Сигнатуры файла")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class FileMetaSignatures {
  @JsonProperty("md5")
  private String md5 = null;

  @JsonProperty("sha256")
  private String sha256 = null;

  public FileMetaSignatures md5(String md5) {
    this.md5 = md5;
    return this;
  }

   /**
   * MD5 содержимого файла
   * @return md5
  **/
  @ApiModelProperty(required = true, value = "MD5 содержимого файла")
  public String getMd5() {
    return md5;
  }

  public void setMd5(String md5) {
    this.md5 = md5;
  }

  public FileMetaSignatures sha256(String sha256) {
    this.sha256 = sha256;
    return this;
  }

   /**
   * SHA256 содержимого файла
   * @return sha256
  **/
  @ApiModelProperty(required = true, value = "SHA256 содержимого файла")
  public String getSha256() {
    return sha256;
  }

  public void setSha256(String sha256) {
    this.sha256 = sha256;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileMetaSignatures fileMetaSignatures = (FileMetaSignatures) o;
    return Objects.equals(this.md5, fileMetaSignatures.md5) &&
        Objects.equals(this.sha256, fileMetaSignatures.sha256);
  }

  @Override
  public int hashCode() {
    return Objects.hash(md5, sha256);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileMetaSignatures {\n");
    
    sb.append("    md5: ").append(toIndentedString(md5)).append("\n");
    sb.append("    sha256: ").append(toIndentedString(sha256)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

