/*
 * Valitydev Platform Analytics API
 * ## Описание Valitydev Analytics API является точкой взаимодействия с аналитической и поисковой частью платформы. Все аналитическоие запросы осуществляются с помощью вызовов соответствующих методов API. Любые сторонние приложения, включая наши веб-сайты, личные кабинеты и другие UI-интерфейсы являются внешними приложениями-клиентами. Valitydev Analytics API работает поверх HTTP-протокола. Мы используем REST архитектуру, схема описывается в соответствии со [Swagger](http://swagger.io/). Коды возврата описываются соответствующими HTTP-статусами. Платформа принимает и возвращает JSON-структуры в HTTP body. ## Запросы Любой вызов методов API обязан предваряться предоставлением уникального для участника в пределах платформы ID запроса. Данный ID передается в соответствующем заголовке HTTP-запроса: ```  X-Request-ID: oX5MWM2AQy ``` Платформа гарантирует идемпотентность запросов, отправленных с одинаковым ID. ## Тип содержимого и кодировка Любой запрос к API должен выполняться в кодировке UTF-8 и с указанием содержимого в формате JSON ```   Content-Type: application/json; charset=utf-8 ``` ## Формат дат Платформа принимает значения date-time в стандарте ISO 8601 с обязательным указанием UTC-оффсета, например: ```   2017-01-01T00:00:00Z   2017-01-01T00:00:01+00:00 ``` ## Максимальное время обработки запроса К любому вызову методов API можно добавить параметр отсечки по времени, определяющий максимальное время ожидания завершения операции по запросу. Данная отсечка передается в соответствующем заголовке HTTP-запроса: ```  X-Request-Deadline: 10s ``` Значение отсечки может быть задано в формате ISO 8601 (см. [Формат дат](#section/Format-dat)), либо в относительных величинах, например: `150000ms`, `540s`, `3.5m` При этом возможные единицы измерения `ms`, `s`, `m`. В обоих случаях  не рекомендуется, чтобы задаваемое значение было меньше **3 секунд** и превышало **1 минуту**. ## Поиск по магазинам API предоставляет несколько различных критериев для выбора магазинов, в рамках которых будет выполняться поиск или аналитика: `shopID`, `shopIDs`, `paymentInstitutionRealm`. В случае использования нескольких критериев одновременно в выборку будут включены магазины, подпадающие под хотя бы один из перечисленных критериев. 
 *
 * OpenAPI spec version: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.ChargebackReason;
import dev.vality.swag.analytics.model.Content;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;

/**
 * Chargeback
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
public class Chargeback {
  @JsonProperty("invoiceId")
  private String invoiceId = null;

  @JsonProperty("paymentId")
  private String paymentId = null;

  @JsonProperty("chargebackId")
  private String chargebackId = null;

  @JsonProperty("externalId")
  private String externalId = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("levyAmount")
  private Long levyAmount = null;

  @JsonProperty("levyCurrency")
  private String levyCurrency = null;

  @JsonProperty("bodyAmount")
  private Long bodyAmount = null;

  @JsonProperty("bodyCurrency")
  private String bodyCurrency = null;

  @JsonProperty("fee")
  private Long fee = null;

  @JsonProperty("providerFee")
  private Long providerFee = null;

  @JsonProperty("externalFee")
  private Long externalFee = null;

  /**
   * Статус чарджбэка
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    ACCEPTED("accepted"),
    
    REJECTED("rejected"),
    
    CANCELLED("cancelled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  /**
   * Этап прохождения чарджбэка
   */
  public enum StageEnum {
    CHARGEBACK("chargeback"),
    
    PRE_ARBITRATION("pre_arbitration"),
    
    ARBITRATION("arbitration");

    private String value;

    StageEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StageEnum fromValue(String text) {
      for (StageEnum b : StageEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("stage")
  private StageEnum stage = null;

  @JsonProperty("chargebackReason")
  private ChargebackReason chargebackReason = null;

  @JsonProperty("content")
  private Content content = null;

  public Chargeback invoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * Идентификатор инвойса
   * @return invoiceId
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  public String getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
  }

  public Chargeback paymentId(String paymentId) {
    this.paymentId = paymentId;
    return this;
  }

   /**
   * Идентификатор платежа
   * @return paymentId
  **/
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  public Chargeback chargebackId(String chargebackId) {
    this.chargebackId = chargebackId;
    return this;
  }

   /**
   * Идентификатор чарджбэка
   * @return chargebackId
  **/
  @ApiModelProperty(required = true, value = "Идентификатор чарджбэка")
  public String getChargebackId() {
    return chargebackId;
  }

  public void setChargebackId(String chargebackId) {
    this.chargebackId = chargebackId;
  }

  public Chargeback externalId(String externalId) {
    this.externalId = externalId;
    return this;
  }

   /**
   * Внешний идентификатор
   * @return externalId
  **/
  @ApiModelProperty(value = "Внешний идентификатор")
  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public Chargeback shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

   /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Chargeback createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Chargeback levyAmount(Long levyAmount) {
    this.levyAmount = levyAmount;
    return this;
  }

   /**
   * Сумма списываемых средств у чарджбека
   * minimum: 1
   * @return levyAmount
  **/
  @ApiModelProperty(required = true, value = "Сумма списываемых средств у чарджбека")
  public Long getLevyAmount() {
    return levyAmount;
  }

  public void setLevyAmount(Long levyAmount) {
    this.levyAmount = levyAmount;
  }

  public Chargeback levyCurrency(String levyCurrency) {
    this.levyCurrency = levyCurrency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return levyCurrency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getLevyCurrency() {
    return levyCurrency;
  }

  public void setLevyCurrency(String levyCurrency) {
    this.levyCurrency = levyCurrency;
  }

  public Chargeback bodyAmount(Long bodyAmount) {
    this.bodyAmount = bodyAmount;
    return this;
  }

   /**
   * Сумма чарджбэка
   * minimum: 1
   * @return bodyAmount
  **/
  @ApiModelProperty(required = true, value = "Сумма чарджбэка")
  public Long getBodyAmount() {
    return bodyAmount;
  }

  public void setBodyAmount(Long bodyAmount) {
    this.bodyAmount = bodyAmount;
  }

  public Chargeback bodyCurrency(String bodyCurrency) {
    this.bodyCurrency = bodyCurrency;
    return this;
  }

   /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return bodyCurrency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  public String getBodyCurrency() {
    return bodyCurrency;
  }

  public void setBodyCurrency(String bodyCurrency) {
    this.bodyCurrency = bodyCurrency;
  }

  public Chargeback fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  **/
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public Chargeback providerFee(Long providerFee) {
    this.providerFee = providerFee;
    return this;
  }

   /**
   * Комиссия провайдера, в минорных денежных единицах
   * minimum: 0
   * @return providerFee
  **/
  @ApiModelProperty(value = "Комиссия провайдера, в минорных денежных единицах")
  public Long getProviderFee() {
    return providerFee;
  }

  public void setProviderFee(Long providerFee) {
    this.providerFee = providerFee;
  }

  public Chargeback externalFee(Long externalFee) {
    this.externalFee = externalFee;
    return this;
  }

   /**
   * Комиссия внешней системы системы, в минорных денежных единицах
   * minimum: 0
   * @return externalFee
  **/
  @ApiModelProperty(value = "Комиссия внешней системы системы, в минорных денежных единицах")
  public Long getExternalFee() {
    return externalFee;
  }

  public void setExternalFee(Long externalFee) {
    this.externalFee = externalFee;
  }

  public Chargeback status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Статус чарджбэка
   * @return status
  **/
  @ApiModelProperty(value = "Статус чарджбэка")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Chargeback stage(StageEnum stage) {
    this.stage = stage;
    return this;
  }

   /**
   * Этап прохождения чарджбэка
   * @return stage
  **/
  @ApiModelProperty(value = "Этап прохождения чарджбэка")
  public StageEnum getStage() {
    return stage;
  }

  public void setStage(StageEnum stage) {
    this.stage = stage;
  }

  public Chargeback chargebackReason(ChargebackReason chargebackReason) {
    this.chargebackReason = chargebackReason;
    return this;
  }

   /**
   * Get chargebackReason
   * @return chargebackReason
  **/
  @ApiModelProperty(value = "")
  public ChargebackReason getChargebackReason() {
    return chargebackReason;
  }

  public void setChargebackReason(ChargebackReason chargebackReason) {
    this.chargebackReason = chargebackReason;
  }

  public Chargeback content(Content content) {
    this.content = content;
    return this;
  }

   /**
   * Get content
   * @return content
  **/
  @ApiModelProperty(value = "")
  public Content getContent() {
    return content;
  }

  public void setContent(Content content) {
    this.content = content;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Chargeback chargeback = (Chargeback) o;
    return Objects.equals(this.invoiceId, chargeback.invoiceId) &&
        Objects.equals(this.paymentId, chargeback.paymentId) &&
        Objects.equals(this.chargebackId, chargeback.chargebackId) &&
        Objects.equals(this.externalId, chargeback.externalId) &&
        Objects.equals(this.shopID, chargeback.shopID) &&
        Objects.equals(this.createdAt, chargeback.createdAt) &&
        Objects.equals(this.levyAmount, chargeback.levyAmount) &&
        Objects.equals(this.levyCurrency, chargeback.levyCurrency) &&
        Objects.equals(this.bodyAmount, chargeback.bodyAmount) &&
        Objects.equals(this.bodyCurrency, chargeback.bodyCurrency) &&
        Objects.equals(this.fee, chargeback.fee) &&
        Objects.equals(this.providerFee, chargeback.providerFee) &&
        Objects.equals(this.externalFee, chargeback.externalFee) &&
        Objects.equals(this.status, chargeback.status) &&
        Objects.equals(this.stage, chargeback.stage) &&
        Objects.equals(this.chargebackReason, chargeback.chargebackReason) &&
        Objects.equals(this.content, chargeback.content);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, paymentId, chargebackId, externalId, shopID, createdAt, levyAmount, levyCurrency, bodyAmount, bodyCurrency, fee, providerFee, externalFee, status, stage, chargebackReason, content);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Chargeback {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    paymentId: ").append(toIndentedString(paymentId)).append("\n");
    sb.append("    chargebackId: ").append(toIndentedString(chargebackId)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    levyAmount: ").append(toIndentedString(levyAmount)).append("\n");
    sb.append("    levyCurrency: ").append(toIndentedString(levyCurrency)).append("\n");
    sb.append("    bodyAmount: ").append(toIndentedString(bodyAmount)).append("\n");
    sb.append("    bodyCurrency: ").append(toIndentedString(bodyCurrency)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    providerFee: ").append(toIndentedString(providerFee)).append("\n");
    sb.append("    externalFee: ").append(toIndentedString(externalFee)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    stage: ").append(toIndentedString(stage)).append("\n");
    sb.append("    chargebackReason: ").append(toIndentedString(chargebackReason)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

