package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.ApiClient;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse20010;
import dev.vality.swag.analytics.model.InlineResponse20011;
import dev.vality.swag.analytics.model.InlineResponse20012;
import dev.vality.swag.analytics.model.InlineResponse2008;
import dev.vality.swag.analytics.model.InlineResponse2009;
import java.time.OffsetDateTime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
@Component("dev.vality.swag.analytics.api.SearchApi")
public class SearchApi {
    private ApiClient apiClient;

    public SearchApi() {
        this(new ApiClient());
    }

    @Autowired
    public SearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Поиск чарджбэков
     * <p><b>200</b> - Найденные чарджбэки
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param offset Смещение выборки
     * @param invoiceID Идентификатор инвойса
     * @param paymentID Идентификатор платежа
     * @param chargebackID Идентификатор чарджбэка
     * @param chargebackStatuses Статусы чарджбэков
     * @param chargebackStages Этапы чарджбэков
     * @param chargebackCategories Категории чарджбэков
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse2008
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2008 searchChargebacks(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, Integer offset, String invoiceID, String paymentID, String chargebackID, List<String> chargebackStatuses, List<String> chargebackStages, List<String> chargebackCategories, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchChargebacks");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchChargebacks");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchChargebacks");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchChargebacks");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchChargebacks");
        }
        
        String path = UriComponentsBuilder.fromPath("/chargebacks").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offset", offset));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentID", paymentID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "chargebackID", chargebackID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "chargebackStatuses", chargebackStatuses));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "chargebackStages", chargebackStages));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "chargebackCategories", chargebackCategories));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2008> returnType = new ParameterizedTypeReference<InlineResponse2008>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Поиск инвойсов
     * <p><b>200</b> - Найденные инвойсы
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param invoiceIDs Список инвойсов
     * @param invoiceStatus Статус инвойса для поиска
     * @param invoiceID Идентификатор инвойса
     * @param externalID Внешний идентификатор
     * @param invoiceAmountFrom Минимальная сумма инвойса
     * @param invoiceAmountTo Максимальная сумма инвойса
     * @param excludedShops Идентификаторы магазинов, исключаемых из поиска
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse2009
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2009 searchInvoices(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, List<String> invoiceIDs, String invoiceStatus, String invoiceID, String externalID, Long invoiceAmountFrom, Long invoiceAmountTo, List<String> excludedShops, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchInvoices");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchInvoices");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchInvoices");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchInvoices");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchInvoices");
        }
        
        String path = UriComponentsBuilder.fromPath("/invoices").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "invoiceIDs", invoiceIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceStatus", invoiceStatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "externalID", externalID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceAmountFrom", invoiceAmountFrom));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceAmountTo", invoiceAmountTo));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludedShops", excludedShops));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2009> returnType = new ParameterizedTypeReference<InlineResponse2009>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Поиск платежей
     * <p><b>200</b> - Найденные платежи
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param invoiceIDs Список инвойсов
     * @param paymentStatus Статус платежа для поиска
     * @param paymentFlow Flow платежа
     * @param paymentMethod Метод оплаты
     * @param paymentTerminalProvider Провайдер платежного терминала
     * @param invoiceID Идентификатор инвойса
     * @param paymentID Идентификатор платежа
     * @param externalID Внешний идентификатор
     * @param payerEmail Email, указанный при оплате
     * @param payerIP IP-адрес плательщика
     * @param payerFingerprint Уникальный отпечаток user agent&#39;а плательщика
     * @param customerID Идентификатор плательщика
     * @param first6 Первые 6 цифр номера карты
     * @param last4 Последние 4 цифры номера карты
     * @param rrn Retrieval Reference Number
     * @param approvalCode Authorization Approval Code
     * @param bankCardTokenProvider Провайдер платежных токенов
     * @param bankCardPaymentSystem Платежная система
     * @param paymentAmountFrom Минимальная сумма платежа
     * @param paymentAmountTo Максимальная сумма платежа
     * @param excludedShops Идентификаторы магазинов, исключаемых из поиска
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse20010
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse20010 searchPayments(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, List<String> invoiceIDs, String paymentStatus, String paymentFlow, String paymentMethod, String paymentTerminalProvider, String invoiceID, String paymentID, String externalID, String payerEmail, String payerIP, String payerFingerprint, String customerID, String first6, String last4, String rrn, String approvalCode, String bankCardTokenProvider, String bankCardPaymentSystem, Long paymentAmountFrom, Long paymentAmountTo, List<String> excludedShops, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchPayments");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchPayments");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchPayments");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchPayments");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchPayments");
        }
        
        String path = UriComponentsBuilder.fromPath("/payments").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "invoiceIDs", invoiceIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentStatus", paymentStatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentFlow", paymentFlow));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentMethod", paymentMethod));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentTerminalProvider", paymentTerminalProvider));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentID", paymentID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "externalID", externalID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerEmail", payerEmail));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerIP", payerIP));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payerFingerprint", payerFingerprint));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "customerID", customerID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "first6", first6));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "last4", last4));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "rrn", rrn));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "approvalCode", approvalCode));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bankCardTokenProvider", bankCardTokenProvider));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bankCardPaymentSystem", bankCardPaymentSystem));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentAmountFrom", paymentAmountFrom));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentAmountTo", paymentAmountTo));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludedShops", excludedShops));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse20010> returnType = new ParameterizedTypeReference<InlineResponse20010>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Поиск выплат
     * <p><b>200</b> - Найденные выплаты
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param offset Смещение выборки
     * @param payoutID Идентификатор выплаты
     * @param payoutToolType Тип выплаты для поиска   * PayoutAccount - выплата на банковский счёт   * Wallet - выплата на кошелёк   * PaymentInstitutionAccount - выплата на счёт платежной организации 
     * @param excludedShops Идентификаторы магазинов, исключаемых из поиска
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse20011
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse20011 searchPayouts(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, Integer offset, String payoutID, String payoutToolType, List<String> excludedShops, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchPayouts");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchPayouts");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchPayouts");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchPayouts");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchPayouts");
        }
        
        String path = UriComponentsBuilder.fromPath("/payouts").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offset", offset));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payoutID", payoutID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "payoutToolType", payoutToolType));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludedShops", excludedShops));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse20011> returnType = new ParameterizedTypeReference<InlineResponse20011>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Поиск возвратов
     * <p><b>200</b> - Найденные возвраты
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param limit Лимит выборки
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param offset Смещение выборки
     * @param invoiceIDs Список инвойсов
     * @param invoiceID Идентификатор инвойса
     * @param paymentID Идентификатор платежа
     * @param refundID Идентификатор возврата
     * @param externalID Внешний идентификатор
     * @param refundStatus Статус возврата
     * @param excludedShops Идентификаторы магазинов, исключаемых из поиска
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse20012
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse20012 searchRefunds(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, Integer limit, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, Integer offset, List<String> invoiceIDs, String invoiceID, String paymentID, String refundID, String externalID, String refundStatus, List<String> excludedShops, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchRefunds");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchRefunds");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchRefunds");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchRefunds");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling searchRefunds");
        }
        
        String path = UriComponentsBuilder.fromPath("/refunds").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "offset", offset));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "invoiceIDs", invoiceIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "invoiceID", invoiceID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentID", paymentID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "refundID", refundID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "externalID", externalID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "refundStatus", refundStatus));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludedShops", excludedShops));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse20012> returnType = new ParameterizedTypeReference<InlineResponse20012>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
