package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.ApiClient;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse20013;
import dev.vality.swag.analytics.model.InlineResponse400;
import dev.vality.swag.analytics.model.InlineResponse4001;
import java.time.OffsetDateTime;
import dev.vality.swag.analytics.model.Report;
import dev.vality.swag.analytics.model.ReportLink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
@Component("dev.vality.swag.analytics.api.ReportsApi")
public class ReportsApi {
    private ApiClient apiClient;

    public ReportsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Отменить указанный отчет. Отчеты типа &#x60;provisionOfService&#x60; отменить нельзя
     * <p><b>202</b> - Запрос на отмену отчета принят
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param reportID Идентификатор отчета
     * @param xRequestDeadline Максимальное время обработки запроса
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void cancelReport(String xRequestID, Long reportID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling cancelReport");
        }
        
        // verify the required parameter 'reportID' is set
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling cancelReport");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("reportID", reportID);
        String path = UriComponentsBuilder.fromPath("/reports/{reportID}/cancel").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>() {};
        apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени
     * <p><b>201</b> - Отчет создан
     * <p><b>400</b> - Ошибочные данные для генерации
     * <p><b>401</b> - Ошибка авторизации
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param reportType Тип отчета
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @return Report
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Report createReport(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String reportType, String xRequestDeadline, String shopID) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling createReport");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling createReport");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling createReport");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling createReport");
        }
        
        // verify the required parameter 'reportType' is set
        if (reportType == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportType' when calling createReport");
        }
        
        String path = UriComponentsBuilder.fromPath("/reports").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "reportType", reportType));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<Report> returnType = new ParameterizedTypeReference<Report>() {};
        return apiClient.invokeAPI(path, HttpMethod.POST, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Скачать файл
     * <p><b>200</b> - Download link
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param reportID Идентификатор отчета
     * @param fileID Идентификатор файла
     * @param xRequestDeadline Максимальное время обработки запроса
     * @return ReportLink
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ReportLink downloadFile(String xRequestID, Long reportID, String fileID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling downloadFile");
        }
        
        // verify the required parameter 'reportID' is set
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling downloadFile");
        }
        
        // verify the required parameter 'fileID' is set
        if (fileID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fileID' when calling downloadFile");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("reportID", reportID);
        uriVariables.put("fileID", fileID);
        String path = UriComponentsBuilder.fromPath("/reports/{reportID}/files/{fileID}/download").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<ReportLink> returnType = new ParameterizedTypeReference<ReportLink>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получить отчет по данному идентификатору
     * <p><b>200</b> - Найденный отчет
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param reportID Идентификатор отчета
     * @param xRequestDeadline Максимальное время обработки запроса
     * @return Report
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Report getReport(String xRequestID, Long reportID, String xRequestDeadline) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getReport");
        }
        
        // verify the required parameter 'reportID' is set
        if (reportID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportID' when calling getReport");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("reportID", reportID);
        String path = UriComponentsBuilder.fromPath("/reports/{reportID}").buildAndExpand(uriVariables).toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<Report> returnType = new ParameterizedTypeReference<Report>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получить список отчетов по данному магазину за период
     * <p><b>200</b> - Найденные отчеты
     * <p><b>400</b> - Ошибочные данные для получения
     * <p><b>401</b> - Ошибка авторизации
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param reportTypes Типы отчетов
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopID Идентификатор магазина
     * @param shopIDs Идентификаторы магазинов
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @param limit Лимит выборки
     * @param continuationToken Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. 
     * @return InlineResponse20013
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse20013 searchReports(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, List<String> reportTypes, String xRequestDeadline, String shopID, List<String> shopIDs, String paymentInstitutionRealm, Integer limit, String continuationToken) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling searchReports");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling searchReports");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling searchReports");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling searchReports");
        }
        
        // verify the required parameter 'reportTypes' is set
        if (reportTypes == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'reportTypes' when calling searchReports");
        }
        
        String path = UriComponentsBuilder.fromPath("/reports").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "shopID", shopID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "reportTypes", reportTypes));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "continuationToken", continuationToken));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse20013> returnType = new ParameterizedTypeReference<InlineResponse20013>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
