package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.ApiClient;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse200;
import dev.vality.swag.analytics.model.InlineResponse2001;
import dev.vality.swag.analytics.model.InlineResponse2002;
import dev.vality.swag.analytics.model.InlineResponse2003;
import dev.vality.swag.analytics.model.InlineResponse2004;
import dev.vality.swag.analytics.model.InlineResponse2005;
import dev.vality.swag.analytics.model.InlineResponse2006;
import dev.vality.swag.analytics.model.InlineResponse2007;
import java.time.OffsetDateTime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-04-14T08:34:17.349Z")
@Component("dev.vality.swag.analytics.api.AnalyticsApi")
public class AnalyticsApi {
    private ApiClient apiClient;

    public AnalyticsApi() {
        this(new ApiClient());
    }

    @Autowired
    public AnalyticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * 
     * Получение среднего размера платежа с группировкой по валютам
     * <p><b>200</b> - Средний размер платежа с группировкой по валютам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2001
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2001 getAveragePayment(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getAveragePayment");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getAveragePayment");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getAveragePayment");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getAveragePayment");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/average").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2001> returnType = new ParameterizedTypeReference<InlineResponse2001>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение текущего баланса по магазину
     * <p><b>200</b> - Список оборотов с группировкой по валютам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2001
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2001 getCurrentBalances(String xRequestID, String partyID, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getCurrentBalances");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getCurrentBalances");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/balances/current").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2001> returnType = new ParameterizedTypeReference<InlineResponse2001>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение текущего баланса с группировкой по магазинам
     * <p><b>200</b> - Список балансов с группировкой по магазинам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @return InlineResponse200
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse200 getCurrentBalancesGroupByShop(String xRequestID, String partyID, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getCurrentBalancesGroupByShop");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getCurrentBalancesGroupByShop");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/balances/current-shop-balances").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse200> returnType = new ParameterizedTypeReference<InlineResponse200>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение списка оборотов с группировкой по валютам
     * <p><b>200</b> - Список оборотов с группировкой по валютам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2001
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2001 getPaymentsAmount(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsAmount");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsAmount");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsAmount");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsAmount");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/amount").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2001> returnType = new ParameterizedTypeReference<InlineResponse2001>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение количества платежей с группировкой по валютам
     * <p><b>200</b> - Среднее количество платежей с группировкой по валютам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2003
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2003 getPaymentsCount(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsCount");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsCount");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsCount");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsCount");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/count").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2003> returnType = new ParameterizedTypeReference<InlineResponse2003>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение распределения ошибок
     * <p><b>200</b> - Распределение ошибок
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2004
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2004 getPaymentsErrorDistribution(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsErrorDistribution");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsErrorDistribution");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsErrorDistribution");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsErrorDistribution");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/errors").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2004> returnType = new ParameterizedTypeReference<InlineResponse2004>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам
     * <p><b>200</b> - Список оборотов с группировкой по валютам и разделенные по временным интервалам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param splitUnit Единица времени сегмента разбиения
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2005
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2005 getPaymentsSplitAmount(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String splitUnit, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsSplitAmount");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsSplitAmount");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsSplitAmount");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsSplitAmount");
        }
        
        // verify the required parameter 'splitUnit' is set
        if (splitUnit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'splitUnit' when calling getPaymentsSplitAmount");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/split-amount").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "splitUnit", splitUnit));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2005> returnType = new ParameterizedTypeReference<InlineResponse2005>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам
     * <p><b>200</b> - Количество платежей с группировкой по валютам и статусам, разделенное по временным интервалам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param splitUnit Единица времени сегмента разбиения
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2006
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2006 getPaymentsSplitCount(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String splitUnit, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsSplitCount");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsSplitCount");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsSplitCount");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsSplitCount");
        }
        
        // verify the required parameter 'splitUnit' is set
        if (splitUnit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'splitUnit' when calling getPaymentsSplitCount");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/split-count").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "splitUnit", splitUnit));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2006> returnType = new ParameterizedTypeReference<InlineResponse2006>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение распределения ошибок с подошибками
     * <p><b>200</b> - Распределение ошибок с подошибками
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2007
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2007 getPaymentsSubErrorDistribution(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsSubErrorDistribution");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsSubErrorDistribution");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsSubErrorDistribution");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsSubErrorDistribution");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments/sub-errors").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2007> returnType = new ParameterizedTypeReference<InlineResponse2007>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение распределения использования платежных инструментов
     * <p><b>200</b> - Распределение использования платежных инструментов
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2002
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2002 getPaymentsToolDistribution(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getPaymentsToolDistribution");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getPaymentsToolDistribution");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getPaymentsToolDistribution");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getPaymentsToolDistribution");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/payments-tool").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2002> returnType = new ParameterizedTypeReference<InlineResponse2002>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
    /**
     * 
     * Получение списка возвратов с группировкой по валютам
     * <p><b>200</b> - Список возвратов с группировкой по валютам
     * <p><b>400</b> - Неверные данные
     * <p><b>401</b> - Ошибка авторизации
     * <p><b>404</b> - Заданный ресурс не найден
     * @param xRequestID Уникальный идентификатор запроса к системе
     * @param partyID Уникальный идентификатор участника в рамках платформы
     * @param fromTime Начало временного отрезка
     * @param toTime Конец временного отрезка
     * @param xRequestDeadline Максимальное время обработки запроса
     * @param shopIDs Идентификаторы магазинов
     * @param excludeShopIDs Идентификаторы магазинов не включаемые в запрос
     * @param paymentInstitutionRealm Тип магазина, тестовый или «боевой»
     * @return InlineResponse2001
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public InlineResponse2001 getRefundsAmount(String xRequestID, String partyID, OffsetDateTime fromTime, OffsetDateTime toTime, String xRequestDeadline, List<String> shopIDs, List<String> excludeShopIDs, String paymentInstitutionRealm) throws RestClientException {
        Object postBody = null;
        
        // verify the required parameter 'xRequestID' is set
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getRefundsAmount");
        }
        
        // verify the required parameter 'partyID' is set
        if (partyID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'partyID' when calling getRefundsAmount");
        }
        
        // verify the required parameter 'fromTime' is set
        if (fromTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fromTime' when calling getRefundsAmount");
        }
        
        // verify the required parameter 'toTime' is set
        if (toTime == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'toTime' when calling getRefundsAmount");
        }
        
        String path = UriComponentsBuilder.fromPath("/analytics/refunds/amount").build().toUriString();
        
        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();
        
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "partyID", partyID));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "shopIDs", shopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase()), "excludeShopIDs", excludeShopIDs));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "paymentInstitutionRealm", paymentInstitutionRealm));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "fromTime", fromTime));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "toTime", toTime));
        
        if (xRequestID != null)
        headerParams.add("X-Request-ID", apiClient.parameterToString(xRequestID));
        if (xRequestDeadline != null)
        headerParams.add("X-Request-Deadline", apiClient.parameterToString(xRequestDeadline));

        final String[] accepts = { 
            "application/json; charset=utf-8"
        };
        final List<MediaType> accept = apiClient.selectHeaderAccept(accepts);
        final String[] contentTypes = { 
            "application/json; charset=utf-8"
        };
        final MediaType contentType = apiClient.selectHeaderContentType(contentTypes);

        String[] authNames = new String[] { "bearer" };

        ParameterizedTypeReference<InlineResponse2001> returnType = new ParameterizedTypeReference<InlineResponse2001>() {};
        return apiClient.invokeAPI(path, HttpMethod.GET, queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }
}
