/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.StatusOffsetCount;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;

@Validated
public class SplitCountResult {
    @JsonProperty(value="splitUnit")
    private SplitUnitEnum splitUnit = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="statusOffsetCounts")
    @Valid
    private List<StatusOffsetCount> statusOffsetCounts = new ArrayList<StatusOffsetCount>();

    public SplitCountResult splitUnit(SplitUnitEnum splitUnit) {
        this.splitUnit = splitUnit;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u044f")
    @NotNull
    public SplitUnitEnum getSplitUnit() {
        return this.splitUnit;
    }

    public void setSplitUnit(SplitUnitEnum splitUnit) {
        this.splitUnit = splitUnit;
    }

    public SplitCountResult currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SplitCountResult statusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
        this.statusOffsetCounts = statusOffsetCounts;
        return this;
    }

    public SplitCountResult addStatusOffsetCountsItem(StatusOffsetCount statusOffsetCountsItem) {
        this.statusOffsetCounts.add(statusOffsetCountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public List<StatusOffsetCount> getStatusOffsetCounts() {
        return this.statusOffsetCounts;
    }

    public void setStatusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
        this.statusOffsetCounts = statusOffsetCounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitCountResult splitCountResult = (SplitCountResult)o;
        return Objects.equals((Object)this.splitUnit, (Object)splitCountResult.splitUnit) && Objects.equals(this.currency, splitCountResult.currency) && Objects.equals(this.statusOffsetCounts, splitCountResult.statusOffsetCounts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.splitUnit, this.currency, this.statusOffsetCounts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitCountResult {\n");
        sb.append("    splitUnit: ").append(this.toIndentedString((Object)this.splitUnit)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    statusOffsetCounts: ").append(this.toIndentedString(this.statusOffsetCounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SplitUnitEnum {
        MINUTE("minute"),
        HOUR("hour"),
        DAY("day"),
        WEEK("week"),
        MONTH("month"),
        YEAR("year");

        private String value;

        private SplitUnitEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SplitUnitEnum fromValue(String text) {
            for (SplitUnitEnum b : SplitUnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

